/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.systems;

import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import sophisticated.building.ClientConfig;
import sophisticated.building.ClientEvents;
import sophisticated.building.SophisticatedBuildingClient;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.buildmode.BuildModeEnum;
import sophisticated.building.compatibility.CompatHelper;
import sophisticated.building.network.message.ServerBreakBlocksPacket;
import sophisticated.building.network.message.ServerPlaceBlocksPacket;
import sophisticated.building.utilities.BlockEntry;
import sophisticated.building.utilities.BlockSet;
import sophisticated.building.utilities.ClientBlockUtilities;
import sophisticated.building.utilities.SurvivalHelper;

@OnlyIn(value=Dist.CLIENT)
public class BuilderChain {
    private final BlockSet blocks = new BlockSet();
    private Item previousHeldItem;
    private int soundTime = 0;
    private BlockEntry startPosForPlacing;
    private BlockPos startPosForBreaking;
    private BlockHitResult lookingAtNear;
    private BlockHitResult lookingAt;
    private Vec3 lastPlayerPos;
    private Vec3 lastPlayerLook;
    private int ticksSinceLastFullUpdate = 0;
    private static final int MIN_TICKS_BETWEEN_UPDATES = 1;
    private boolean forceUpdate = true;
    private BuildingState buildingState = BuildingState.IDLE;
    private AbilitiesState abilitiesState = AbilitiesState.CAN_PLACE_AND_BREAK;

    public void onRightClick() {
        if (this.abilitiesState != AbilitiesState.CAN_PLACE_AND_BREAK || this.buildingState == BuildingState.BREAKING) {
            this.cancel();
            return;
        }
        if (this.buildingState == BuildingState.IDLE) {
            this.buildingState = BuildingState.PLACING;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        BuildModeEnum buildMode = SophisticatedBuildingClient.BUILD_MODES.getBuildMode();
        if (buildMode.instance.onClick(this.blocks)) {
            this.buildingState = BuildingState.IDLE;
            if (!this.blocks.isEmpty()) {
                this.randomizeBlockStatesFresh((Player)player, player.getItemInHand(InteractionHand.MAIN_HAND));
                SophisticatedBuildingClient.BLOCK_PREVIEWS.onBlocksPlaced(this.blocks);
                ClientBlockUtilities.playSoundIfFurtherThanNormal((Player)player, this.blocks.getLastBlockEntry(), false);
                player.swing(InteractionHand.MAIN_HAND);
                this.blocks.skipFirst = buildMode == BuildModeEnum.DISABLED;
                long placeTime = player.level().getGameTime();
                if (this.blocks.size() > 1) {
                    placeTime += (long)((Integer)ClientConfig.visuals.appearAnimationLength.get()).intValue();
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerPlaceBlocksPacket(this.blocks, placeTime), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void onLeftClick() {
        if (this.abilitiesState == AbilitiesState.NONE || this.buildingState == BuildingState.PLACING) {
            this.cancel();
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!AttachmentHandler.canBreakFar((Player)player)) {
            return;
        }
        if (this.buildingState == BuildingState.IDLE) {
            this.buildingState = BuildingState.BREAKING;
            this.blocks.setStartPos(new BlockEntry(this.startPosForBreaking));
            SophisticatedBuildingClient.BUILD_MODIFIERS.findCoordinates(this.blocks, (Player)player);
            SophisticatedBuildingClient.BUILDER_FILTER.filterOnCoordinates(this.blocks, (Player)player);
            this.findExistingBlockStates(player.level());
            SophisticatedBuildingClient.BUILDER_FILTER.filterOnExistingBlockStates(this.blocks, (Player)player);
        }
        BuildModeEnum buildMode = SophisticatedBuildingClient.BUILD_MODES.getBuildMode();
        if (buildMode.instance.onClick(this.blocks)) {
            this.buildingState = BuildingState.IDLE;
            if (!this.blocks.isEmpty()) {
                SophisticatedBuildingClient.BLOCK_PREVIEWS.onBlocksBroken(this.blocks);
                ClientBlockUtilities.playSoundIfFurtherThanNormal((Player)player, this.blocks.getLastBlockEntry(), true);
                player.swing(InteractionHand.MAIN_HAND);
                this.blocks.skipFirst = buildMode == BuildModeEnum.DISABLED;
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerBreakBlocksPacket(this.blocks), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void onTick() {
        BlockSet.ClientSide.tickCooldown();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ClientLevel world = mc.level;
        Vec3 currentPos = player.position();
        Vec3 currentLook = player.getLookAngle();
        boolean playerMoved = this.lastPlayerPos == null || currentPos.distanceToSqr(this.lastPlayerPos) > 0.001 || currentLook.distanceToSqr(this.lastPlayerLook) > 1.0E-4;
        ++this.ticksSinceLastFullUpdate;
        boolean throttlingEnabled = (Boolean)ClientConfig.performance.enableUpdateThrottling.get();
        if (throttlingEnabled && !this.forceUpdate && !playerMoved && this.buildingState == BuildingState.IDLE && this.ticksSinceLastFullUpdate < 1) {
            return;
        }
        HashSet<BlockPos> previousCoordinates = new HashSet<BlockPos>(this.blocks.getCoordinates());
        this.blocks.clear();
        this.startPosForPlacing = null;
        this.startPosForBreaking = null;
        this.lookingAtNear = null;
        this.abilitiesState = this.determineAbilities(mc, (Player)player, (Level)world);
        if (this.abilitiesState == AbilitiesState.NONE) {
            this.lastPlayerPos = currentPos;
            this.lastPlayerLook = currentLook;
            return;
        }
        BuildModeEnum buildMode = SophisticatedBuildingClient.BUILD_MODES.getBuildMode();
        if (this.buildingState == BuildingState.IDLE) {
            BlockEntry startEntry = this.findStartPosition((Player)player, buildMode);
            if (startEntry != null) {
                this.blocks.setStartPos(startEntry);
            } else {
                this.abilitiesState = AbilitiesState.NONE;
                return;
            }
        }
        SophisticatedBuildingClient.BUILD_MODES.findCoordinates(this.blocks, (Player)player);
        SophisticatedBuildingClient.BUILD_MODIFIERS.findCoordinates(this.blocks, (Player)player);
        SophisticatedBuildingClient.BUILDER_FILTER.filterOnCoordinates(this.blocks, (Player)player);
        if (buildMode == BuildModeEnum.DISABLED && this.blocks.size() <= 1) {
            this.abilitiesState = AbilitiesState.NONE;
            return;
        }
        this.findExistingBlockStates((Level)world);
        SophisticatedBuildingClient.BUILDER_FILTER.filterOnExistingBlockStates(this.blocks, (Player)player);
        ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        this.findNewBlockStates((Player)player, heldItem);
        if (this.previousHeldItem != heldItem.getItem() || !previousCoordinates.equals(this.blocks.getCoordinates())) {
            this.onBlocksChanged((Player)player);
        }
        this.previousHeldItem = heldItem.getItem();
        this.lastPlayerPos = currentPos;
        this.lastPlayerLook = currentLook;
        this.ticksSinceLastFullUpdate = 0;
        this.forceUpdate = false;
    }

    public void requestUpdate() {
        this.forceUpdate = true;
    }

    private AbilitiesState determineAbilities(Minecraft mc, Player player, Level world) {
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult != null && hitResult.getType() == HitResult.Type.BLOCK) {
            this.lookingAtNear = (BlockHitResult)hitResult;
        }
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        boolean blockInHand = CompatHelper.isItemBlockProxy(itemStack);
        boolean lookingAtInteractiveObject = ClientBlockUtilities.determineIfLookingAtInteractiveObject(mc, world);
        boolean isShiftKeyDown = player.isShiftKeyDown();
        if (lookingAtInteractiveObject && !isShiftKeyDown) {
            return AbilitiesState.NONE;
        }
        if (!blockInHand) {
            return AbilitiesState.CAN_BREAK;
        }
        return AbilitiesState.CAN_PLACE_AND_BREAK;
    }

    private BlockEntry findStartPosition(Player player, BuildModeEnum buildMode) {
        BlockEntry blockEntry;
        int maxReach = AttachmentHandler.getPlacementReach(player, false);
        boolean shouldLookAtNear = buildMode == BuildModeEnum.DISABLED || maxReach < 3;
        this.lookingAt = shouldLookAtNear ? this.lookingAtNear : ClientBlockUtilities.getLookingAtFar(player);
        if (this.lookingAt == null || this.lookingAt.getType() == HitResult.Type.MISS) {
            return null;
        }
        BlockPos startPos = this.lookingAt.getBlockPos();
        if (!shouldLookAtNear && player.blockPosition().distSqr((Vec3i)startPos) > (double)(maxReach * maxReach)) {
            return null;
        }
        this.startPosForBreaking = startPos;
        if (this.abilitiesState == AbilitiesState.CAN_PLACE_AND_BREAK) {
            boolean shouldOffsetStartPosition = SophisticatedBuildingClient.BUILD_SETTINGS.shouldOffsetStartPosition();
            boolean replaceable = player.level().getBlockState(startPos).canBeReplaced();
            boolean becomesDoubleSlab = SurvivalHelper.doesBecomeDoubleSlab(player, startPos);
            if (!(shouldOffsetStartPosition || replaceable || becomesDoubleSlab)) {
                startPos = startPos.relative(this.lookingAt.getDirection());
            }
        } else if (!shouldLookAtNear && !AttachmentHandler.canBreakFar(player)) {
            return null;
        }
        this.startPosForPlacing = blockEntry = new BlockEntry(startPos);
        return blockEntry;
    }

    private void findExistingBlockStates(Level world) {
        for (BlockEntry blockEntry : this.blocks) {
            blockEntry.existingBlockState = world.getBlockState(blockEntry.blockPos);
        }
    }

    private void findNewBlockStates(Player player, ItemStack heldItem) {
        if (this.buildingState == BuildingState.BREAKING) {
            return;
        }
        Direction originalDirection = player.getDirection();
        Direction clickedFace = this.lookingAt.getDirection();
        Vec3 relativeHitVec = this.lookingAt.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)this.lookingAt.getBlockPos()));
        SophisticatedBuildingClient.ITEM_USAGE_TRACKER.initialize();
        Iterator iter = this.blocks.entrySet().iterator();
        while (iter.hasNext()) {
            BlockEntry blockEntry = (BlockEntry)iter.next().getValue();
            ItemStack itemStack = this.determineItemStack(player, heldItem, blockEntry.blockPos);
            if (itemStack == null || itemStack.isEmpty()) {
                iter.remove();
                continue;
            }
            blockEntry.setItemAndFindNewBlockState(itemStack, player.level(), originalDirection, clickedFace, relativeHitVec);
            if (SophisticatedBuildingClient.BUILDER_FILTER.filterOnNewBlockState(blockEntry, player)) {
                iter.remove();
                continue;
            }
            blockEntry.invalid = !SophisticatedBuildingClient.ITEM_USAGE_TRACKER.increaseUsageCount(itemStack.getItem(), 1, player);
        }
        SophisticatedBuildingClient.ITEM_USAGE_TRACKER.calculateMissingItems(player);
    }

    private void randomizeBlockStatesFresh(Player player, ItemStack heldItem) {
        if (!CompatHelper.isItemBlockProxy(heldItem, false)) {
            return;
        }
        if (heldItem.getItem() instanceof BlockItem) {
            return;
        }
        Direction originalDirection = player.getDirection();
        Direction clickedFace = this.lookingAt.getDirection();
        Vec3 relativeHitVec = this.lookingAt.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)this.lookingAt.getBlockPos()));
        for (BlockEntry blockEntry : this.blocks) {
            ItemStack itemStack = CompatHelper.getItemBlockFromStackFresh(heldItem, player);
            if (itemStack == null || itemStack.isEmpty()) continue;
            blockEntry.setItemAndFindNewBlockState(itemStack, player.level(), originalDirection, clickedFace, relativeHitVec);
        }
    }

    private ItemStack determineItemStack(Player player, ItemStack heldItem, BlockPos blockPos) {
        if (heldItem.getItem() instanceof BlockItem) {
            return heldItem;
        }
        if (CompatHelper.isItemBlockProxy(heldItem, false)) {
            return CompatHelper.getItemBlockForPosition(heldItem, blockPos, player);
        }
        return null;
    }

    private void onBlocksChanged(Player player) {
        if (this.blocks.size() > 1 && this.soundTime < ClientEvents.ticksInGame) {
            this.soundTime = ClientEvents.ticksInGame;
            if (this.blocks.getLastBlockEntry() != null && this.blocks.getLastBlockEntry().newBlockState != null) {
                BlockState lastBlockState = this.blocks.getLastBlockEntry().newBlockState;
                SoundType soundType = lastBlockState.getBlock().getSoundType(lastBlockState, (LevelReader)player.level(), this.blocks.lastPos, (Entity)player);
                SoundEvent soundEvent = this.buildingState == BuildingState.BREAKING ? soundType.getBreakSound() : soundType.getPlaceSound();
                player.level().playSound(player, player.blockPosition(), soundEvent, SoundSource.BLOCKS, 0.3f, 0.8f);
            }
        }
    }

    public void cancel() {
        if (this.buildingState == BuildingState.IDLE) {
            return;
        }
        this.buildingState = BuildingState.IDLE;
        SophisticatedBuildingClient.BUILD_MODES.onCancel();
        Minecraft.getInstance().player.playSound(SoundEvents.UI_TOAST_OUT, 4.0f, 1.0f);
    }

    public BlockSet getBlocks() {
        return this.blocks;
    }

    public BuildingState getBuildingState() {
        return this.buildingState;
    }

    public AbilitiesState getAbilitiesState() {
        return this.abilitiesState;
    }

    public BuildingState getPretendBuildingState() {
        if (this.buildingState != BuildingState.IDLE) {
            return this.buildingState;
        }
        if (this.abilitiesState == AbilitiesState.CAN_PLACE_AND_BREAK) {
            return BuildingState.PLACING;
        }
        if (this.abilitiesState == AbilitiesState.CAN_BREAK) {
            return BuildingState.BREAKING;
        }
        return BuildingState.IDLE;
    }

    public BlockEntry getStartPosForPlacing() {
        return this.startPosForPlacing;
    }

    public BlockPos getStartPosForBreaking() {
        return this.startPosForBreaking;
    }

    public BlockEntry getStartPos() {
        if (this.getPretendBuildingState() == BuildingState.BREAKING) {
            return new BlockEntry(this.getStartPosForBreaking());
        }
        return this.getStartPosForPlacing();
    }

    public BlockHitResult getLookingAtNear() {
        return this.lookingAtNear;
    }

    public static enum BuildingState {
        IDLE,
        PLACING,
        BREAKING;

    }

    public static enum AbilitiesState {
        CAN_PLACE_AND_BREAK,
        CAN_BREAK,
        NONE;

    }
}

