/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.systems;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sophisticated.building.SophisticatedBuildingClient;
import sophisticated.building.compatibility.CompatHelper;
import sophisticated.building.systems.BuildSettings;
import sophisticated.building.systems.BuilderChain;
import sophisticated.building.utilities.BlockEntry;
import sophisticated.building.utilities.BlockSet;
import sophisticated.building.utilities.PlaceChecker;

@OnlyIn(value=Dist.CLIENT)
public class BuilderFilter {
    public void filterOnCoordinates(BlockSet blocks, Player player) {
        Level world = player.level();
        Iterator iter = blocks.entrySet().iterator();
        while (iter.hasNext()) {
            BlockPos pos = ((BlockEntry)iter.next().getValue()).blockPos;
            boolean remove = false;
            if (!world.isLoaded(pos)) {
                remove = true;
            }
            if (!world.getWorldBorder().isWithinBounds(pos)) {
                remove = true;
            }
            if (!remove) continue;
            iter.remove();
        }
    }

    public void filterOnExistingBlockStates(BlockSet blocks, Player player) {
        BuildSettings buildSettings = SophisticatedBuildingClient.BUILD_SETTINGS;
        BuilderChain.BuildingState buildingState = SophisticatedBuildingClient.BUILDER_CHAIN.getPretendBuildingState();
        boolean placing = buildingState == BuilderChain.BuildingState.PLACING;
        Iterator iter = blocks.entrySet().iterator();
        while (iter.hasNext()) {
            ItemStack offhandItem;
            BlockEntry blockEntry = (BlockEntry)iter.next().getValue();
            BlockState blockState = blockEntry.existingBlockState;
            boolean remove = false;
            if (buildSettings.shouldProtectTileEntities() && blockState.hasBlockEntity()) {
                remove = true;
            }
            if (placing && !buildSettings.shouldReplaceFiltered()) {
                if (!buildSettings.shouldReplaceAir() && blockState.isAir()) {
                    remove = true;
                }
                boolean isReplaceable = blockState.canBeReplaced();
                if (!buildSettings.shouldReplaceBlocks() && !isReplaceable) {
                    remove = true;
                }
            }
            if (buildSettings.shouldReplaceFiltered() && !CompatHelper.containsBlock(offhandItem = player.getOffhandItem(), blockState.getBlock())) {
                remove = true;
            }
            if (!remove) continue;
            iter.remove();
        }
    }

    public boolean filterOnNewBlockState(BlockEntry blockEntry, Player player) {
        BuilderChain.BuildingState buildingState = SophisticatedBuildingClient.BUILDER_CHAIN.getPretendBuildingState();
        boolean placing = buildingState == BuilderChain.BuildingState.PLACING;
        boolean remove = false;
        if (placing && !PlaceChecker.shouldPlaceBlock(player.level(), blockEntry)) {
            remove = true;
        }
        return remove;
    }
}

