/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.systems;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import sophisticated.building.ServerConfig;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.utilities.BlockEntry;
import sophisticated.building.utilities.BlockPlacerHelper;
import sophisticated.building.utilities.BlockSet;
import sophisticated.building.utilities.BlockUtilities;
import sophisticated.building.utilities.InventoryHelper;

public class ServerBlockPlacer {
    private boolean isPlacingOrBreakingBlocks = false;
    private final Set<DelayedEntry> delayedEntries = ConcurrentHashMap.newKeySet();
    private final Set<DelayedEntry> delayedEntriesView = Collections.unmodifiableSet(this.delayedEntries);

    public void placeBlocksDelayed(Player player, BlockSet blocks, long placeTime) {
        if (!this.checkAndNotifyAllowedToUseMod(player)) {
            return;
        }
        if (!this.validateBlockSet(player, blocks)) {
            return;
        }
        this.delayedEntries.add(new DelayedEntry(player, blocks, placeTime));
    }

    public void tick() {
        Iterator<DelayedEntry> iterator = this.delayedEntries.iterator();
        while (iterator.hasNext()) {
            DelayedEntry entry = iterator.next();
            if (entry.player.isRemoved()) {
                iterator.remove();
                continue;
            }
            long gameTime = entry.player.level().getGameTime();
            if (gameTime < entry.placeTime) continue;
            this.applyBlockSet(entry.player, entry.blocks);
            iterator.remove();
        }
    }

    public Set<DelayedEntry> getDelayedEntries() {
        return this.delayedEntriesView;
    }

    public void breakBlocks(Player player, BlockSet blocks) {
        this.applyBlockSet(player, blocks);
    }

    public void applyBlockSet(Player player, BlockSet blocks) {
        if (!this.checkAndNotifyAllowedToUseMod(player)) {
            return;
        }
        if (!this.validateBlockSet(player, blocks)) {
            return;
        }
        SophisticatedBuilding.ITEM_USAGE_TRACKER.initialize();
        BlockSet undoSet = new BlockSet();
        for (BlockEntry block : blocks) {
            if (blocks.skipFirst && block.blockPos == blocks.firstPos || !this.applyBlockEntry(player, block)) continue;
            undoSet.add(block);
        }
        SophisticatedBuilding.ITEM_USAGE_TRACKER.calculateMissingItems(player);
        if (!player.isCreative()) {
            InventoryHelper.removeFromInventory(player, SophisticatedBuilding.ITEM_USAGE_TRACKER.placed);
        }
        SophisticatedBuilding.UNDO_REDO.addUndo(player, undoSet);
    }

    public void undoBlockSet(Player player, BlockSet blocks) {
        if (!SophisticatedBuilding.UNDO_REDO.isAllowedToUndo(player)) {
            return;
        }
        SophisticatedBuilding.ITEM_USAGE_TRACKER.initialize();
        BlockSet redoSet = new BlockSet();
        for (BlockEntry block : blocks) {
            if (blocks.skipFirst && block.blockPos == blocks.firstPos || !this.undoBlockEntry(player, block)) continue;
            redoSet.add(block);
        }
        SophisticatedBuilding.ITEM_USAGE_TRACKER.calculateMissingItems(player);
        if (!player.isCreative()) {
            InventoryHelper.removeFromInventory(player, SophisticatedBuilding.ITEM_USAGE_TRACKER.placed);
        }
        SophisticatedBuilding.UNDO_REDO.addRedo(player, redoSet);
    }

    private boolean applyBlockEntry(Player player, BlockEntry block) {
        block.existingBlockState = player.level().getBlockState(block.blockPos);
        boolean breaking = BlockUtilities.isNullOrAir(block.newBlockState);
        if (!this.validateBlockEntry(player, block, breaking)) {
            return false;
        }
        this.isPlacingOrBreakingBlocks = true;
        boolean success = breaking ? BlockPlacerHelper.breakBlock(player, block) : (SophisticatedBuilding.ITEM_USAGE_TRACKER.increaseUsageCount(block.item, 1, player) ? BlockPlacerHelper.placeBlock(player, block) : false);
        this.isPlacingOrBreakingBlocks = false;
        return success;
    }

    private boolean undoBlockEntry(Player player, BlockEntry block) {
        boolean breaking = BlockUtilities.isNullOrAir(block.existingBlockState);
        BlockEntry tempBlockEntry = new BlockEntry(block.blockPos);
        BlockState temp = block.existingBlockState;
        tempBlockEntry.existingBlockState = block.newBlockState;
        tempBlockEntry.newBlockState = temp;
        if (!this.validateBlockEntry(player, tempBlockEntry, breaking)) {
            return false;
        }
        block.newBlockState = player.level().getBlockState(block.blockPos);
        this.isPlacingOrBreakingBlocks = true;
        boolean success = breaking ? BlockPlacerHelper.breakBlock(player, tempBlockEntry) : (SophisticatedBuilding.ITEM_USAGE_TRACKER.increaseUsageCount(tempBlockEntry.item, 1, player) ? BlockPlacerHelper.placeBlock(player, tempBlockEntry) : false);
        this.isPlacingOrBreakingBlocks = false;
        return success;
    }

    private boolean checkAndNotifyAllowedToUseMod(Player player) {
        if (!player.getAbilities().mayBuild) {
            SophisticatedBuilding.log(player, String.valueOf(ChatFormatting.RED) + "You are not allowed to build.");
            return false;
        }
        if (!this.isAllowedToUseMod(player)) {
            SophisticatedBuilding.log(player, String.valueOf(ChatFormatting.RED) + "You are not allowed to use Sophisticated Building.");
            return false;
        }
        return true;
    }

    private boolean isAllowedToUseMod(Player player) {
        if (!((Boolean)ServerConfig.validation.allowInSurvival.get()).booleanValue() && !player.isCreative()) {
            return false;
        }
        if (((Boolean)ServerConfig.validation.useWhitelist.get()).booleanValue()) {
            return ((List)ServerConfig.validation.whitelist.get()).contains(player.getGameProfile().getName());
        }
        return true;
    }

    private boolean validateBlockSet(Player player, BlockSet blocks) {
        if (blocks.isEmpty()) {
            SophisticatedBuilding.log(player, String.valueOf(ChatFormatting.RED) + "No blocks to place.");
            return false;
        }
        if (blocks.skipFirst && blocks.size() == 1 && blocks.iterator().next().blockPos == blocks.firstPos) {
            SophisticatedBuilding.log(player, String.valueOf(ChatFormatting.RED) + "No blocks to place because the first block was skipped.");
            return false;
        }
        if (blocks.size() > (Integer)ServerConfig.validation.maxBlocksPlacedAtOnce.get()) {
            SophisticatedBuilding.log(player, String.valueOf(ChatFormatting.RED) + "Too many blocks to place. Max: " + String.valueOf(ServerConfig.validation.maxBlocksPlacedAtOnce.get()));
            return false;
        }
        if (this.isMixedPlacingAndBreaking(player, blocks)) {
            SophisticatedBuilding.log(player, String.valueOf(ChatFormatting.RED) + "Cannot mix breaking and placing blocks.");
            return false;
        }
        return true;
    }

    private boolean isMixedPlacingAndBreaking(Player player, BlockSet blocks) {
        boolean breaking;
        Iterator<BlockEntry> iterator = blocks.iterator();
        BlockEntry anyBlock = iterator.next();
        if (blocks.skipFirst && anyBlock.blockPos == blocks.firstPos) {
            anyBlock = iterator.next();
        }
        boolean bl = breaking = anyBlock.newBlockState == null || anyBlock.newBlockState.isAir();
        while (iterator.hasNext()) {
            BlockEntry block = iterator.next();
            if (!(block.newBlockState == null || block.newBlockState.isAir() ? !breaking : breaking)) continue;
            return true;
        }
        return false;
    }

    private boolean validateBlockEntry(Player player, BlockEntry block, boolean breaking) {
        if (!player.level().isLoaded(block.blockPos)) {
            return false;
        }
        return !breaking || !BlockUtilities.isNullOrAir(block.existingBlockState);
    }

    public boolean isPlacingOrBreakingBlocks() {
        return this.isPlacingOrBreakingBlocks;
    }

    public record DelayedEntry(Player player, BlockSet blocks, long placeTime) {
    }
}

