/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.systems;

import net.minecraft.world.entity.player.Player;
import sophisticated.building.attachment.AttachmentHandler;

public class ServerBuildState {
    private static final String IS_USING_BUILD_MODE_KEY = "sophisticatedbuilding:isUsingBuildMode";
    private static final String IS_QUICK_REPLACING_KEY = "sophisticatedbuilding:isQuickReplacing";

    public static void handleNewPlayer(Player player) {
        ServerBuildState.setIsUsingBuildMode(player, false);
        ServerBuildState.setIsQuickReplacing(player, false);
    }

    public static boolean isUsingBuildMode(Player player) {
        return player.getPersistentData().contains(IS_USING_BUILD_MODE_KEY);
    }

    public static void setIsUsingBuildMode(Player player, boolean isUsingBuildMode) {
        if (isUsingBuildMode) {
            player.getPersistentData().putBoolean(IS_USING_BUILD_MODE_KEY, true);
        } else {
            player.getPersistentData().remove(IS_USING_BUILD_MODE_KEY);
        }
    }

    public static boolean isQuickReplacing(Player player) {
        if (!AttachmentHandler.canReplaceBlocks(player)) {
            return false;
        }
        return player.getPersistentData().contains(IS_QUICK_REPLACING_KEY);
    }

    public static void setIsQuickReplacing(Player player, boolean isQuickReplacing) {
        if (isQuickReplacing) {
            player.getPersistentData().putBoolean(IS_QUICK_REPLACING_KEY, true);
        } else {
            player.getPersistentData().remove(IS_QUICK_REPLACING_KEY);
        }
    }

    public static boolean isLikeVanilla(Player player) {
        return !ServerBuildState.isUsingBuildMode(player) && !ServerBuildState.isQuickReplacing(player);
    }
}

