/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.systems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import sophisticated.building.ServerConfig;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.utilities.BlockSet;
import sophisticated.building.utilities.FixedStack;
import sophisticated.building.utilities.InventoryHelper;

public class UndoRedo {
    public final Map<UUID, FixedStack<BlockSet>> undoStacks = new HashMap<UUID, FixedStack<BlockSet>>();
    public final Map<UUID, FixedStack<BlockSet>> redoStacks = new HashMap<UUID, FixedStack<BlockSet>>();

    public boolean isAllowedToUndo(Player player) {
        return true;
    }

    public void addUndo(Player player, BlockSet blockSet) {
        if (blockSet.isEmpty() || !this.isAllowedToUndo(player)) {
            return;
        }
        if (!this.undoStacks.containsKey(player.getUUID())) {
            this.undoStacks.put(player.getUUID(), new FixedStack<BlockSet>(new BlockSet[((Integer)ServerConfig.memory.undoStackSize.get()).intValue()]));
        }
        this.undoStacks.get(player.getUUID()).push(blockSet);
    }

    public void addRedo(Player player, BlockSet blockSet) {
        if (blockSet.isEmpty() || !this.isAllowedToUndo(player)) {
            return;
        }
        if (!this.redoStacks.containsKey(player.getUUID())) {
            this.redoStacks.put(player.getUUID(), new FixedStack<BlockSet>(new BlockSet[((Integer)ServerConfig.memory.undoStackSize.get()).intValue()]));
        }
        this.redoStacks.get(player.getUUID()).push(blockSet);
    }

    public boolean undo(Player player) {
        if (!this.isAllowedToUndo(player)) {
            SophisticatedBuilding.log(player, String.valueOf(ChatFormatting.RED) + "You are not allowed to undo.");
            return false;
        }
        if (!this.undoStacks.containsKey(player.getUUID())) {
            return false;
        }
        FixedStack<BlockSet> undoStack = this.undoStacks.get(player.getUUID());
        if (undoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = undoStack.pop();
        SophisticatedBuilding.SERVER_BLOCK_PLACER.undoBlockSet(player, blockSet);
        return true;
    }

    public boolean redo(Player player) {
        if (!this.isAllowedToUndo(player)) {
            SophisticatedBuilding.log(player, String.valueOf(ChatFormatting.RED) + "You are not allowed to undo.");
            return false;
        }
        if (!this.redoStacks.containsKey(player.getUUID())) {
            return false;
        }
        FixedStack<BlockSet> redoStack = this.redoStacks.get(player.getUUID());
        if (redoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = redoStack.pop();
        SophisticatedBuilding.SERVER_BLOCK_PLACER.applyBlockSet(player, blockSet);
        return true;
    }

    public void clear(Player player) {
        if (this.undoStacks.containsKey(player.getUUID())) {
            this.undoStacks.get(player.getUUID()).clear();
        }
        if (this.redoStacks.containsKey(player.getUUID())) {
            this.redoStacks.get(player.getUUID()).clear();
        }
    }

    private List<ItemStack> findItemStacksInInventory(Player player, List<BlockState> blockStates) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(blockStates.size());
        for (BlockState blockState : blockStates) {
            itemStacks.add(this.findItemStackInInventory(player, blockState));
        }
        return itemStacks;
    }

    private ItemStack findItemStackInInventory(Player player, BlockState blockState) {
        ItemStack itemStack = ItemStack.EMPTY;
        if (blockState == null) {
            return itemStack;
        }
        itemStack = InventoryHelper.findItemStackInInventory(player, blockState.getBlock());
        if (itemStack.isEmpty() && !player.level().isClientSide) {
            List itemsDropped = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)player.level()), (BlockPos)BlockPos.ZERO, null);
            for (ItemStack itemStackDropped : itemsDropped) {
                if (!(itemStackDropped.getItem() instanceof BlockItem)) continue;
                Block block = ((BlockItem)itemStackDropped.getItem()).getBlock();
                itemStack = InventoryHelper.findItemStackInInventory(player, block);
            }
        }
        return itemStack;
    }

    public static class UndoSet {
        public final List<BlockSnapshot> blockSnapshots;

        public UndoSet(List<BlockSnapshot> blockSnapshots) {
            this.blockSnapshots = blockSnapshots;
        }
    }
}

