/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.utilities;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import sophisticated.building.create.foundation.utility.BlockHelper;
import sophisticated.building.utilities.BlockEntry;

public class BlockPlacerHelper {
    public static boolean breakBlock(Player player, BlockEntry blockEntry) {
        ItemStack offhand;
        ItemStack usedTool = player.getMainHandItem();
        if ((usedTool.isEmpty() || !(usedTool.getItem() instanceof DiggerItem)) && !(offhand = player.getOffhandItem()).isEmpty() && offhand.getItem() instanceof DiggerItem) {
            usedTool = offhand;
        }
        boolean brokeBlock = BlockHelper.destroyBlockAs(player.level(), blockEntry.blockPos, player, usedTool, 0.0f, stack -> {
            if (!player.isCreative()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            }
        });
        return brokeBlock;
    }

    public static boolean placeBlock(Player player, BlockEntry blockEntry) {
        Level level = player.level();
        ItemStack itemStack = new ItemStack((ItemLike)blockEntry.item);
        level.captureBlockSnapshots = true;
        BlockHelper.placeSchematicBlock(level, blockEntry.newBlockState, blockEntry.blockPos, itemStack, null);
        level.captureBlockSnapshots = false;
        List blockSnapshots = (List)level.capturedBlockSnapshots.clone();
        level.capturedBlockSnapshots.clear();
        Direction side = Direction.UP;
        boolean eventResult = false;
        if (blockSnapshots.size() > 1) {
            eventResult = EventHooks.onMultiBlockPlace((Entity)player, (List)blockSnapshots, (Direction)side);
        } else if (blockSnapshots.size() == 1) {
            eventResult = EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)((BlockSnapshot)blockSnapshots.get(0)), (Direction)side);
        }
        if (eventResult) {
            for (BlockSnapshot blocksnapshot : Lists.reverse((List)blockSnapshots)) {
                level.restoringBlockSnapshots = true;
                blocksnapshot.restore(4);
                level.restoringBlockSnapshots = false;
            }
        } else {
            for (BlockSnapshot snap : blockSnapshots) {
                int updateFlag = snap.getFlags();
                BlockState oldBlock = snap.getState();
                BlockState newBlock = level.getBlockState(snap.getPos());
                newBlock.onPlace(level, snap.getPos(), oldBlock, false);
                level.markAndNotifyBlock(snap.getPos(), level.getChunkAt(snap.getPos()), oldBlock, newBlock, updateFlag, 512);
            }
        }
        level.capturedBlockSnapshots.clear();
        return !eventResult;
    }
}

