/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.utilities;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.utilities.BlockEntry;

public class BlockSet
extends HashMap<BlockPos, BlockEntry>
implements Iterable<BlockEntry> {
    public static boolean logging = false;
    private static int limitWarningCooldown = 0;
    public BlockPos firstPos;
    public BlockPos lastPos;
    public boolean skipFirst;

    public BlockSet() {
    }

    public BlockSet(BlockSet blockSet) {
        super(blockSet);
        this.firstPos = blockSet.firstPos;
        this.lastPos = blockSet.lastPos;
        this.skipFirst = blockSet.skipFirst;
    }

    public BlockSet(List<BlockEntry> blockEntries, BlockPos firstPos, BlockPos lastPos, boolean skipFirst) {
        for (BlockEntry blockEntry : blockEntries) {
            this.add(blockEntry);
        }
        this.firstPos = firstPos;
        this.lastPos = lastPos;
        this.skipFirst = skipFirst;
    }

    public void setStartPos(BlockEntry startPos) {
        this.clear();
        this.add(startPos);
        this.firstPos = startPos.blockPos;
        this.lastPos = startPos.blockPos;
    }

    public void add(BlockEntry blockEntry) {
        if (!this.containsKey(blockEntry.blockPos)) {
            if (FMLEnvironment.dist.isClient()) {
                if (!ClientSide.isFull(this)) {
                    this.put(blockEntry.blockPos, blockEntry);
                }
            } else {
                this.put(blockEntry.blockPos, blockEntry);
            }
        } else if (logging) {
            SophisticatedBuilding.log("BlockSet already contains block at " + String.valueOf(blockEntry.blockPos));
        }
    }

    public HashSet<BlockPos> getCoordinates() {
        return new HashSet<BlockPos>(this.keySet());
    }

    public BlockEntry getFirstBlockEntry() {
        return (BlockEntry)this.get(this.firstPos);
    }

    public BlockEntry getLastBlockEntry() {
        return (BlockEntry)this.get(this.lastPos);
    }

    @Override
    @NotNull
    public Iterator<BlockEntry> iterator() {
        return this.values().iterator();
    }

    public static void encode(FriendlyByteBuf buf, BlockSet block) {
        List<BlockEntry> entries = block.values().stream().filter(be -> !be.invalid).toList();
        ArrayList<Pair> palette = new ArrayList<Pair>();
        HashMap<Pair, Integer> paletteMap = new HashMap<Pair, Integer>();
        for (BlockEntry entry : entries) {
            Pair pair = Pair.of((Object)entry.newBlockState, (Object)entry.item);
            if (paletteMap.containsKey(pair)) continue;
            paletteMap.put(pair, palette.size());
            palette.add(pair);
        }
        buf.writeVarInt(palette.size());
        for (Pair pair : palette) {
            buf.writeNullable((Object)((BlockState)pair.getFirst()), (buffer, state) -> buffer.writeNbt((Tag)NbtUtils.writeBlockState((BlockState)state)));
            buf.writeVarInt(Item.getId((Item)((Item)pair.getSecond())));
        }
        buf.writeVarInt(entries.size());
        BlockPos lastPos = BlockPos.ZERO;
        for (BlockEntry entry : entries) {
            BlockPos pos = entry.blockPos;
            buf.writeVarInt(pos.getX() - lastPos.getX());
            buf.writeVarInt(pos.getY() - lastPos.getY());
            buf.writeVarInt(pos.getZ() - lastPos.getZ());
            lastPos = pos;
            Pair pair = Pair.of((Object)entry.newBlockState, (Object)entry.item);
            buf.writeVarInt(((Integer)paletteMap.get(pair)).intValue());
        }
        buf.writeBlockPos(block.firstPos);
        buf.writeBlockPos(block.lastPos);
        buf.writeBoolean(block.skipFirst);
    }

    public static BlockSet decode(FriendlyByteBuf buf) {
        int paletteSize = buf.readVarInt();
        ArrayList<Pair> palette = new ArrayList<Pair>(paletteSize);
        for (int i = 0; i < paletteSize; ++i) {
            BlockState state = (BlockState)buf.readNullable(buffer -> {
                CompoundTag nbt = buffer.readNbt();
                return nbt == null ? null : NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)nbt);
            });
            Item item = Item.byId((int)buf.readVarInt());
            palette.add(Pair.of((Object)state, (Object)item));
        }
        int blockSize = buf.readVarInt();
        ArrayList<BlockEntry> entries = new ArrayList<BlockEntry>(blockSize);
        BlockPos lastPos = BlockPos.ZERO;
        for (int i = 0; i < blockSize; ++i) {
            BlockPos pos;
            int dx = buf.readVarInt();
            int dy = buf.readVarInt();
            int dz = buf.readVarInt();
            lastPos = pos = lastPos.offset(dx, dy, dz);
            int paletteIndex = buf.readVarInt();
            Pair pair = (Pair)palette.get(paletteIndex);
            BlockEntry entry = new BlockEntry(pos);
            entry.newBlockState = (BlockState)pair.getFirst();
            entry.item = (Item)pair.getSecond();
            entries.add(entry);
        }
        BlockPos firstPos = buf.readBlockPos();
        BlockPos lastPosMeta = buf.readBlockPos();
        boolean skipFirst = buf.readBoolean();
        return new BlockSet(entries, firstPos, lastPosMeta, skipFirst);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientSide {
        private static int cachedLimit = -1;
        private static long lastLimitCheck = 0L;

        public static boolean isFull(BlockSet blockSet) {
            long currentTime = System.currentTimeMillis();
            if (cachedLimit < 0 || currentTime - lastLimitCheck > 1000L) {
                cachedLimit = AttachmentHandler.getMaxBlocksPlacedAtOnce((Player)Minecraft.getInstance().player, false);
                lastLimitCheck = currentTime;
            }
            if (blockSet.size() >= cachedLimit) {
                if (logging && limitWarningCooldown <= 0) {
                    SophisticatedBuilding.log("BlockSet limit reached (" + cachedLimit + " blocks max).");
                    limitWarningCooldown = 20;
                }
                return true;
            }
            return false;
        }

        public static void tickCooldown() {
            if (limitWarningCooldown > 0) {
                --limitWarningCooldown;
            }
        }

        public static void invalidateCache() {
            cachedLimit = -1;
        }
    }
}

