/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.utilities;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sophisticated.building.utilities.BlockEntry;

public class BlockUtilities {
    public static boolean isNullOrAir(BlockState blockState) {
        return blockState == null || blockState.isAir();
    }

    @Deprecated
    public static BlockState getBlockState(Player player, InteractionHand hand, ItemStack blockItemStack, BlockEntry blockEntry, Vec3 relativeHitVec, Direction sideHit) {
        Block block = Block.byItem((Item)blockItemStack.getItem());
        Vec3 hitVec = relativeHitVec.add(Vec3.atLowerCornerOf((Vec3i)blockEntry.blockPos));
        BlockHitResult blockHitResult = new BlockHitResult(hitVec, sideHit, blockEntry.blockPos, false);
        return block.getStateForPlacement(new BlockPlaceContext(player, hand, blockItemStack, blockHitResult));
    }

    public static BlockState getVerticalMirror(BlockState blockState) {
        if (blockState.getBlock() instanceof StairBlock) {
            if (blockState.getValue((Property)StairBlock.HALF) == Half.BOTTOM) {
                return (BlockState)blockState.setValue((Property)StairBlock.HALF, (Comparable)Half.TOP);
            }
            return (BlockState)blockState.setValue((Property)StairBlock.HALF, (Comparable)Half.BOTTOM);
        }
        if (blockState.getBlock() instanceof SlabBlock) {
            if (blockState.getValue((Property)SlabBlock.TYPE) == SlabType.DOUBLE) {
                return blockState;
            }
            if (blockState.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM) {
                return (BlockState)blockState.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP);
            }
            return (BlockState)blockState.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM);
        }
        if (blockState.getBlock() instanceof DirectionalBlock) {
            if (blockState.getValue((Property)DirectionalBlock.FACING) == Direction.DOWN) {
                return (BlockState)blockState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.UP);
            }
            if (blockState.getValue((Property)DirectionalBlock.FACING) == Direction.UP) {
                return (BlockState)blockState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.DOWN);
            }
        }
        if (blockState.getBlock() instanceof DispenserBlock) {
            if (blockState.getValue((Property)DispenserBlock.FACING) == Direction.DOWN) {
                return (BlockState)blockState.setValue((Property)DispenserBlock.FACING, (Comparable)Direction.UP);
            }
            if (blockState.getValue((Property)DispenserBlock.FACING) == Direction.UP) {
                return (BlockState)blockState.setValue((Property)DispenserBlock.FACING, (Comparable)Direction.DOWN);
            }
        }
        return blockState;
    }
}

