/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.utilities;

public class FixedStack<T> {
    private final T[] stack;
    private final int size;
    private int top;
    private int filled = 0;

    public FixedStack(T[] stack) {
        this.stack = stack;
        this.top = 0;
        this.size = stack.length;
    }

    public void push(T object) {
        if (this.top == this.stack.length) {
            this.top = 0;
        }
        this.stack[this.top] = object;
        ++this.top;
        if (this.filled < this.size) {
            ++this.filled;
        }
    }

    public T pop() {
        if (this.filled <= 0) {
            return null;
        }
        if (this.top - 1 < 0) {
            this.top = this.size;
        }
        --this.top;
        T object = this.stack[this.top];
        --this.filled;
        return object;
    }

    public void clear() {
        this.top = 0;
        this.filled = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.filled <= 0;
    }
}

