/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.utilities;

import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.network.PacketDistributor;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.client.ClientBackpackItemCache;
import sophisticated.building.compatibility.CompatHelper;
import sophisticated.building.item.upgrade.BuildingUpgradeHelper;
import sophisticated.building.network.message.BackpackItemCountPacket;

public class InventoryHelper {
    @Deprecated
    public static ItemStack findItemStackInInventory(Player player, Block block) {
        for (ItemStack invStack : player.getInventory().items) {
            if (invStack.isEmpty() || !(invStack.getItem() instanceof BlockItem) || !((BlockItem)invStack.getItem()).getBlock().equals(block)) continue;
            return invStack;
        }
        return ItemStack.EMPTY;
    }

    public static int findTotalBlocksInInventory(Player player, Block block) {
        int total = 0;
        for (ItemStack invStack : player.getInventory().items) {
            if (invStack.isEmpty() || !(invStack.getItem() instanceof BlockItem) || !((BlockItem)invStack.getItem()).getBlock().equals(block)) continue;
            total += invStack.getCount();
        }
        return total;
    }

    public static int findTotalItemsInInventory(Player player, Item item) {
        int maxFromUpgrade;
        int total = 0;
        for (ItemStack invStack : player.getInventory().items) {
            if (invStack.isEmpty() || !invStack.getItem().equals(item)) continue;
            total += invStack.getCount();
        }
        int backpackCount = InventoryHelper.findTotalItemsInBackpacks(player, item);
        if (backpackCount > 0 && (maxFromUpgrade = BuildingUpgradeHelper.getMaxBlocksForPlayer(player)) > 0) {
            total += Math.min(backpackCount, maxFromUpgrade);
        }
        return total;
    }

    public static int findTotalItemsInBackpacks(Player player, Item item) {
        if (player.level().isClientSide()) {
            return ClientBackpackItemCache.getCount(item);
        }
        if (!CompatHelper.isSophisticatedBackpacksLoaded()) {
            return 0;
        }
        try {
            return BuildingUpgradeHelper.countBlockInBackpack(player, new ItemStack((ItemLike)item));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void removeFromInventory(Player player, Map<Item, Integer> items) {
        for (Item item : items.keySet()) {
            int count = items.get(item);
            InventoryHelper.removeFromInventory(player, item, count);
        }
    }

    public static void removeFromInventory(Player player, Item item, int amount) {
        int taken;
        int count;
        ItemStack itemstack;
        if (player.isCreative()) {
            return;
        }
        int amountFound = 0;
        if (CompatHelper.isSophisticatedBackpacksLoaded()) {
            amountFound += InventoryHelper.removeFromBackpacks(player, item, amount - amountFound);
        }
        if (amountFound < amount) {
            int preferredSlot = player.getInventory().selected;
            itemstack = player.getInventory().getItem(preferredSlot);
            count = itemstack.getCount();
            if (itemstack.getItem() == item && count > 0) {
                taken = Math.min(count, amount - amountFound);
                player.getInventory().setItem(preferredSlot, new ItemStack((ItemLike)itemstack.getItem(), count - taken));
                amountFound += taken;
            }
        }
        for (int i = 0; i < player.getInventory().getContainerSize() && amountFound < amount; ++i) {
            itemstack = player.getInventory().getItem(i);
            count = itemstack.getCount();
            if (itemstack.getItem() != item || count <= 0) continue;
            taken = Math.min(count, amount - amountFound);
            player.getInventory().setItem(i, new ItemStack((ItemLike)itemstack.getItem(), count - taken));
            amountFound += taken;
        }
        if (amountFound > 0) {
            player.getInventory().setChanged();
        }
        if (amountFound != amount) {
            SophisticatedBuilding.logError(player.getDisplayName().getString() + " tried to remove " + amount + " " + String.valueOf(item) + " from inventory but only removed " + amountFound);
        }
    }

    public static int removeFromBackpacks(Player player, Item item, int amount) {
        if (!CompatHelper.isSophisticatedBackpacksLoaded()) {
            return 0;
        }
        try {
            int removed;
            int maxFromUpgrade = BuildingUpgradeHelper.getMaxBlocksForPlayer(player);
            if (maxFromUpgrade <= 0) {
                return 0;
            }
            int requested = Math.min(amount, maxFromUpgrade);
            ItemStack extracted = BuildingUpgradeHelper.extractBlockFromBackpack(player, new ItemStack((ItemLike)item), requested, false);
            int n = removed = extracted.isEmpty() ? 0 : extracted.getCount();
            if (removed > 0 && player.level().isClientSide()) {
                return removed;
            }
            if (removed > 0 && player.level().getServer() != null) {
                int newCount = BuildingUpgradeHelper.countBlockInBackpack(player, new ItemStack((ItemLike)item));
                ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)item);
                if (key != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new BackpackItemCountPacket(key, newCount), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            return removed;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

