/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.utilities;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import sophisticated.building.compatibility.CompatHelper;

public class SurvivalHelper {
    public static boolean canBreak(Level world, Player player, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        if (!world.getFluidState(pos).isEmpty()) {
            return false;
        }
        if (player.isCreative()) {
            return true;
        }
        return EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)blockState, (BlockGetter)world, (BlockPos)pos);
    }

    public static boolean doesBecomeDoubleSlab(Player player, BlockPos pos) {
        BlockState placedBlockState = player.level().getBlockState(pos);
        ItemStack itemstack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (CompatHelper.isItemBlockProxy(itemstack)) {
            itemstack = CompatHelper.getItemBlockFromStack(itemstack);
        }
        if (itemstack.isEmpty() || !(itemstack.getItem() instanceof BlockItem) || !(((BlockItem)itemstack.getItem()).getBlock() instanceof SlabBlock)) {
            return false;
        }
        SlabBlock heldSlab = (SlabBlock)((BlockItem)itemstack.getItem()).getBlock();
        if (placedBlockState.getBlock() == heldSlab) {
            // empty if block
        }
        return false;
    }
}

