/*
 * Decompiled with CFR 0.152.
 */
package com.netherairtune.pixelart;

import com.netherairtune.pixelart.BlockColorMapping;
import com.netherairtune.pixelart.BlockSnapshot;
import com.netherairtune.pixelart.DirectionOffsetCalculator;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ImageRenderer {
    private List<BlockSnapshot> undoHistory = null;
    private final int maxDimension = 100;

    public void renderImage(String imageUrl, class_3222 player, int startX, int startY, int startZ, class_3218 world, int maxHeight, String orientation, boolean eraseMode) {
        boolean debugMode = false;
        this.undoHistory = new ArrayList<BlockSnapshot>();
        BlockColorMapping colorMapper = new BlockColorMapping();
        DirectionOffsetCalculator offsetCalculator = new DirectionOffsetCalculator();
        try {
            URL url = new URL(imageUrl);
            BufferedImage image = null;
            InputStream inputStream = url.openStream();
            if (inputStream.available() > 0) {
                image = ImageIO.read(inputStream);
            } else {
                image = ImageIO.read(inputStream);
                if (image == null) {
                    player.method_64398((class_2561)class_2561.method_43470((String)("Failed to read image from URL: " + imageUrl)));
                    return;
                }
            }
            Raster raster = image.getData();
            Rectangle bounds = raster.getBounds();
            player.method_64398((class_2561)class_2561.method_43470((String)("Image resolution: " + bounds.width + " x " + bounds.height)));
            if (raster.getTransferType() != 0) {
                player.method_64398((class_2561)class_2561.method_43470((String)"Image format not supported. Must be byte-based."));
                return;
            }
            boolean hasAlpha = false;
            int colorChannels = raster.getNumDataElements();
            if (colorChannels == 4) {
                hasAlpha = true;
            }
            double scaleFactor = 1.0;
            if (maxHeight > 0) {
                if (maxHeight >= 100) {
                    maxHeight = 100;
                }
            } else {
                maxHeight = bounds.height > 100 ? 100 : bounds.height;
            }
            if (bounds.height > maxHeight) {
                scaleFactor = (double)maxHeight / (double)bounds.height;
            }
            if ((int)((double)bounds.width * scaleFactor) > 100) {
                scaleFactor = 100.0 / (double)bounds.width;
            }
            int scaledHeight = (int)((double)bounds.height * scaleFactor);
            int scaledWidth = (int)((double)bounds.width * scaleFactor);
            int[] offsets = offsetCalculator.calculateOffsets(startX, startY, startZ, scaledWidth, scaledHeight, orientation);
            int xDirection = offsets[0];
            int xStart = offsets[1];
            int xXComponent = offsets[3];
            int xYComponent = offsets[4];
            int yDirection = offsets[5];
            int yStart = offsets[6];
            int yXComponent = offsets[8];
            int yYComponent = offsets[9];
            int zDirection = offsets[10];
            int zStart = offsets[11];
            int zXComponent = offsets[13];
            int zYComponent = offsets[14];
            int currentX = xStart;
            int currentY = yStart;
            int currentZ = zStart;
            for (int heightIndex = scaledHeight - 1; heightIndex >= 0; --heightIndex) {
                for (int widthIndex = 0; widthIndex < scaledWidth; ++widthIndex) {
                    int sourceX = (int)((double)widthIndex / scaleFactor);
                    int sourceY = (int)((double)heightIndex / scaleFactor);
                    Color color = new Color(image.getRGB(sourceX, sourceY), hasAlpha);
                    int red = color.getRed();
                    int green = color.getGreen();
                    int blue = color.getBlue();
                    class_2338 pos = new class_2338(currentX, currentY, currentZ);
                    class_2248 oldBlock = world.method_8320(pos).method_26204();
                    this.undoHistory.add(new BlockSnapshot(currentX, currentY, currentZ, oldBlock));
                    class_2248 newBlock = class_2246.field_10124;
                    if (!eraseMode) {
                        newBlock = colorMapper.findClosestBlock(red, green, blue);
                    }
                    currentX += xDirection * xXComponent;
                    currentY += yDirection * yXComponent;
                    currentZ += zDirection * zXComponent;
                    int alpha = 255;
                    if (hasAlpha && (alpha = color.getAlpha()) < 10) continue;
                    world.method_8501(pos, newBlock.method_9564());
                }
                if (xXComponent != 0) {
                    currentX = offsets[1];
                }
                if (yXComponent != 0) {
                    currentY = offsets[6];
                }
                if (zXComponent != 0) {
                    currentZ = offsets[11];
                }
                currentX += xDirection * xYComponent;
                currentY += yDirection * yYComponent;
                currentZ += zDirection * zYComponent;
            }
        }
        catch (IOException e) {
            player.method_64398((class_2561)class_2561.method_43470((String)("Error loading image: " + e.getMessage())));
        }
    }

    public void undoLastRender(class_3222 player, class_3218 world) {
        if (this.undoHistory == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)"No render to undo."));
            return;
        }
        for (BlockSnapshot snapshot : this.undoHistory) {
            class_2338 pos = new class_2338(snapshot.xPosition, snapshot.yPosition, snapshot.zPosition);
            world.method_8501(pos, snapshot.blockType.method_9564());
        }
        this.undoHistory = null;
        player.method_64398((class_2561)class_2561.method_43470((String)"Render undone."));
    }
}

