/*
 * Decompiled with CFR 0.152.
 */
package com.netherairtune.pixelart;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public class BlockColorMapping {
    private final Map<class_2248, int[]> blockColorMap = new HashMap<class_2248, int[]>();

    public BlockColorMapping() {
        this.blockColorMap.put(class_2246.field_10104, new int[]{146, 99, 86});
        this.blockColorMap.put(class_2246.field_10460, new int[]{158, 164, 176});
        this.blockColorMap.put(class_2246.field_10381, new int[]{18, 18, 18});
        this.blockColorMap.put(class_2246.field_10418, new int[]{115, 115, 115});
        this.blockColorMap.put(class_2246.field_10445, new int[]{122, 122, 122});
        this.blockColorMap.put(class_2246.field_10201, new int[]{97, 219, 213});
        this.blockColorMap.put(class_2246.field_10442, new int[]{129, 140, 143});
        this.blockColorMap.put(class_2246.field_10566, new int[]{134, 96, 67});
        this.blockColorMap.put(class_2246.field_10234, new int[]{81, 217, 117});
        this.blockColorMap.put(class_2246.field_10013, new int[]{109, 128, 116});
        this.blockColorMap.put(class_2246.field_10181, new int[]{113, 113, 113});
        this.blockColorMap.put(class_2246.field_10205, new int[]{249, 236, 78});
        this.blockColorMap.put(class_2246.field_10571, new int[]{143, 139, 124});
        this.blockColorMap.put(class_2246.field_10255, new int[]{126, 124, 122});
        this.blockColorMap.put(class_2246.field_10085, new int[]{219, 219, 219});
        this.blockColorMap.put(class_2246.field_10212, new int[]{135, 130, 126});
        this.blockColorMap.put(class_2246.field_10009, new int[]{185, 133, 28});
        this.blockColorMap.put(class_2246.field_10441, new int[]{38, 67, 137});
        this.blockColorMap.put(class_2246.field_10090, new int[]{102, 112, 134});
        this.blockColorMap.put(class_2246.field_9989, new int[]{103, 121, 103});
        this.blockColorMap.put(class_2246.field_10266, new int[]{44, 22, 26});
        this.blockColorMap.put(class_2246.field_10515, new int[]{111, 54, 52});
        this.blockColorMap.put(class_2246.field_10540, new int[]{20, 18, 29});
        this.blockColorMap.put(class_2246.field_10225, new int[]{165, 194, 245});
        this.blockColorMap.put(class_2246.field_46282, new int[]{142, 76, 12});
        this.blockColorMap.put(class_2246.field_10002, new int[]{171, 27, 9});
        this.blockColorMap.put(class_2246.field_10080, new int[]{132, 107, 107});
        this.blockColorMap.put(class_2246.field_10102, new int[]{219, 211, 160});
        this.blockColorMap.put(class_2246.field_9979, new int[]{219, 211, 160});
        this.blockColorMap.put(class_2246.field_10114, new int[]{84, 64, 51});
        this.blockColorMap.put(class_2246.field_10258, new int[]{194, 195, 84});
        this.blockColorMap.put(class_2246.field_10340, new int[]{125, 125, 125});
    }

    private int calculateColorDistance(class_2248 block, int red, int green, int blue) {
        int[] blockColor = this.blockColorMap.get(block);
        int redDiff = blockColor[0] - red;
        int greenDiff = blockColor[1] - green;
        int blueDiff = blockColor[2] - blue;
        return redDiff * redDiff + greenDiff * greenDiff + blueDiff * blueDiff;
    }

    public class_2248 findClosestBlock(int red, int green, int blue) {
        class_2248 closestBlock = null;
        int minDistance = 0;
        for (class_2248 block : this.blockColorMap.keySet()) {
            if (closestBlock == null) {
                closestBlock = block;
                minDistance = this.calculateColorDistance(block, red, green, blue);
                continue;
            }
            int distance = this.calculateColorDistance(block, red, green, blue);
            if (distance >= minDistance) continue;
            closestBlock = block;
            minDistance = distance;
        }
        return closestBlock;
    }
}

