/*
 * Decompiled with CFR 0.152.
 */
package com.example.arrowrecovery;

import com.example.arrowrecovery.ArrowRecoveryConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowHitTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ArrowRecovery");
    private static final ConcurrentHashMap<UUID, Integer> regularArrowCounts = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, List<class_1844>> tippedArrowsWithEffect = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, ArrowOwnershipData> arrowOwnership = new ConcurrentHashMap();
    private static long lastGlobalCleanup = System.currentTimeMillis();
    private static final long CLEANUP_INTERVAL_MS = 15000L;
    private static final int MAX_ARROW_OWNERSHIP = 5000;
    private static final long ARROW_EXPIRY_MS = 300000L;
    private static final int PARTICLE_STICK_COUNT = 4;
    private static final int PARTICLE_PLANK_COUNT = 6;
    private static final int PARTICLE_SMOKE_COUNT = 2;
    private static final double PARTICLE_SPREAD = 0.05;
    private static final double PARTICLE_SPEED = 0.01;
    private static final double SMOKE_SPEED = 0.001;

    public static void registerHit(class_1309 entity, class_1937 world, class_243 hitPos, class_1665 arrow) {
        ArrowOwnershipData ownershipData;
        class_1799 stack = arrow.method_7445();
        if (!stack.method_31573(class_3489.field_18317)) {
            return;
        }
        UUID entityId = entity.method_5667();
        UUID arrowId = arrow.method_5667();
        if (arrow.field_7572 == class_1665.class_1666.field_7594 && !ArrowRecoveryConfig.shouldRecoverInfinityArrows()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastGlobalCleanup > 15000L) {
            ArrowHitTracker.cleanupOldArrows(currentTime);
            lastGlobalCleanup = currentTime;
        }
        if ((ownershipData = arrowOwnership.get(arrowId)) != null) {
            if (!ownershipData.entityId.equals(entityId)) {
                if (ArrowRecoveryConfig.isDebugLogging() && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Arrow {} already claimed by {}, ignoring hit on {}", new Object[]{arrowId, ownershipData.entityId, entityId});
                }
                return;
            }
            return;
        }
        int totalTracked = regularArrowCounts.size() + tippedArrowsWithEffect.size();
        if (totalTracked >= ArrowRecoveryConfig.getMaxTrackedEntities()) {
            if (ArrowRecoveryConfig.isDebugLogging() && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Max tracked entities reached ({}), ignoring arrow hit", (Object)totalTracked);
            }
            return;
        }
        if (ThreadLocalRandom.current().nextFloat() >= ArrowRecoveryConfig.getHitChance()) {
            ArrowHitTracker.showArrowBrokenEffect(entity, (class_3218)world, hitPos);
            arrowOwnership.put(arrowId, new ArrowOwnershipData(entityId, currentTime));
            return;
        }
        arrowOwnership.put(arrowId, new ArrowOwnershipData(entityId, currentTime));
        if (stack.method_31574(class_1802.field_8087)) {
            class_1844 potionContents = (class_1844)stack.method_58694(class_9334.field_49651);
            if (potionContents != null && ThreadLocalRandom.current().nextFloat() < ArrowRecoveryConfig.getTippedArrowEffectChance()) {
                List updatedList = tippedArrowsWithEffect.compute(entityId, (key, list) -> {
                    if (list == null) {
                        list = new ArrayList<class_1844>();
                    }
                    if (list.size() < ArrowRecoveryConfig.getMaxArrowsPerEntity()) {
                        list.add(potionContents);
                    }
                    return list;
                });
                if (ArrowRecoveryConfig.isDebugLogging() && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Tipped arrow with effect tracked for {}. Count: {}", (Object)entityId, (Object)updatedList.size());
                }
            } else {
                int newCount = regularArrowCounts.compute(entityId, (key, currentCount) -> {
                    int count = (currentCount == null ? 0 : currentCount) + 1;
                    return Math.min(count, ArrowRecoveryConfig.getMaxArrowsPerEntity());
                });
                if (ArrowRecoveryConfig.isDebugLogging() && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Tipped arrow lost effect, tracked as regular for {}. Count: {}", (Object)entityId, (Object)newCount);
                }
            }
        } else {
            int newCount = regularArrowCounts.compute(entityId, (key, currentCount) -> {
                int count = (currentCount == null ? 0 : currentCount) + 1;
                return Math.min(count, ArrowRecoveryConfig.getMaxArrowsPerEntity());
            });
            if (ArrowRecoveryConfig.isDebugLogging() && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Regular arrow tracked for {}. Count: {}", (Object)entityId, (Object)newCount);
            }
        }
    }

    private static void showArrowBrokenEffect(class_1309 entity, class_3218 world, class_243 hitPos) {
        world.method_65096((class_2394)new class_2392(class_2398.field_11218, class_1802.field_8600.method_7854()), hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, 4, 0.05, 0.05, 0.05, 0.01);
        world.method_65096((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10161.method_9564()), hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, 6, 0.05, 0.05, 0.05, 0.01);
        world.method_65096((class_2394)class_2398.field_46911, hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, 2, 0.05, 0.05, 0.05, 0.001);
        world.method_60511(null, hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, (class_6880)class_3417.field_15075, class_3419.field_15254, 0.8f, 1.2f);
    }

    private static void cleanupOldArrows(long currentTime) {
        int sizeBefore = arrowOwnership.size();
        arrowOwnership.entrySet().removeIf(entry -> currentTime - ((ArrowOwnershipData)entry.getValue()).timestamp > 300000L);
        if (arrowOwnership.size() > 5000) {
            int toRemove = 1000;
            ArrayList<Map.Entry<UUID, ArrowOwnershipData>> entries = new ArrayList<Map.Entry<UUID, ArrowOwnershipData>>(arrowOwnership.entrySet());
            entries.sort(Comparator.comparingLong(e -> ((ArrowOwnershipData)e.getValue()).timestamp));
            for (int i = 0; i < toRemove && i < entries.size(); ++i) {
                arrowOwnership.remove(((Map.Entry)entries.get(i)).getKey());
            }
        }
        int sizeAfter = arrowOwnership.size();
        if (ArrowRecoveryConfig.isDebugLogging() && sizeBefore != sizeAfter) {
            LOGGER.info("Cleaned up arrow ownership tracking: {} -> {} arrows ({} removed)", new Object[]{sizeBefore, sizeAfter, sizeBefore - sizeAfter});
        }
    }

    public static ArrowDropData removeAndGetData(UUID entityId) {
        Integer regularCount = regularArrowCounts.remove(entityId);
        List<class_1844> tippedWithEffect = tippedArrowsWithEffect.remove(entityId);
        return new ArrowDropData(regularCount != null ? regularCount : 0, tippedWithEffect != null ? tippedWithEffect : Collections.emptyList());
    }

    public static void clearCount(UUID entityId) {
        regularArrowCounts.remove(entityId);
        tippedArrowsWithEffect.remove(entityId);
    }

    public static String getStats() {
        int tippedEffectCount = tippedArrowsWithEffect.values().stream().mapToInt(List::size).sum();
        return String.format("Tracking %d entities (%d regular, %d tipped+effect, %d arrows in flight)", regularArrowCounts.size() + tippedArrowsWithEffect.size(), regularArrowCounts.values().stream().mapToInt(Integer::intValue).sum(), tippedEffectCount, arrowOwnership.size());
    }

    private static class ArrowOwnershipData {
        final UUID entityId;
        final long timestamp;

        ArrowOwnershipData(UUID entityId, long timestamp) {
            this.entityId = entityId;
            this.timestamp = timestamp;
        }
    }

    public static class ArrowDropData {
        public final int regularArrowCount;
        public final List<class_1844> tippedArrowsWithEffect;

        public ArrowDropData(int regularArrowCount, List<class_1844> tippedArrowsWithEffect) {
            this.regularArrowCount = regularArrowCount;
            this.tippedArrowsWithEffect = tippedArrowsWithEffect;
        }

        public boolean hasArrows() {
            return this.regularArrowCount > 0 || !this.tippedArrowsWithEffect.isEmpty();
        }
    }
}

