/*
 * Decompiled with CFR 0.152.
 */
package com.example.arrowrecovery;

import com.example.arrowrecovery.ConfigManager;
import java.util.HashSet;
import java.util.Set;

public class ArrowRecoveryConfig {
    private static volatile boolean cachedModEnabled;
    private static volatile float cachedHitChance;
    private static volatile int cachedMaxArrowsPerEntity;
    private static volatile int cachedMaxTrackedEntities;
    private static volatile boolean cachedDebugLogging;
    private static volatile int cachedStatsIntervalTicks;
    private static volatile float cachedTippedArrowEffectChance;
    private static volatile boolean cachedAllowMobArrows;
    private static volatile boolean cachedRecoverInfinityArrows;
    private static volatile Set<String> cachedProjectileDenyList;
    private static volatile Set<String> cachedTargetDenyList;

    public static void refreshCache() {
        ConfigManager.Config config = ConfigManager.getConfig();
        cachedModEnabled = config.modEnabled;
        cachedHitChance = config.hitChance;
        cachedMaxArrowsPerEntity = config.maxArrowsPerEntity;
        cachedMaxTrackedEntities = config.maxTrackedEntities;
        cachedDebugLogging = config.debugLogging;
        cachedStatsIntervalTicks = config.statsIntervalTicks;
        cachedTippedArrowEffectChance = config.tippedArrowEffectChance;
        cachedAllowMobArrows = config.allowMobArrows;
        cachedRecoverInfinityArrows = config.recoverInfinityArrows;
        cachedProjectileDenyList = new HashSet<String>(config.projectileDenyList);
        cachedTargetDenyList = new HashSet<String>(config.targetDenyList);
    }

    public static boolean isModEnabled() {
        return cachedModEnabled;
    }

    public static float getHitChance() {
        return cachedHitChance;
    }

    public static int getMaxArrowsPerEntity() {
        return cachedMaxArrowsPerEntity;
    }

    public static int getMaxTrackedEntities() {
        return cachedMaxTrackedEntities;
    }

    public static boolean isDebugLogging() {
        return cachedDebugLogging;
    }

    public static int getStatsIntervalTicks() {
        return cachedStatsIntervalTicks;
    }

    public static float getTippedArrowEffectChance() {
        return cachedTippedArrowEffectChance;
    }

    public static boolean shouldAllowMobArrows() {
        return cachedAllowMobArrows;
    }

    public static boolean shouldRecoverInfinityArrows() {
        return cachedRecoverInfinityArrows;
    }

    public static boolean hasProjectileDenyList() {
        return !cachedProjectileDenyList.isEmpty();
    }

    public static boolean hasTargetDenyList() {
        return !cachedTargetDenyList.isEmpty();
    }

    public static boolean isProjectileDenied(String projectileId) {
        return cachedProjectileDenyList.contains(projectileId);
    }

    public static boolean isTargetDenied(String targetId) {
        return cachedTargetDenyList.contains(targetId);
    }

    static {
        ArrowRecoveryConfig.refreshCache();
    }
}

