/*
 * Decompiled with CFR 0.152.
 */
package com.example.arrowrecovery;

import com.example.arrowrecovery.ArrowHitTracker;
import com.example.arrowrecovery.ArrowRecoveryConfig;
import com.example.arrowrecovery.ConfigManager;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowRecoveryMod
implements ModInitializer {
    public static final String MOD_ID = "arrowrecovery";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"arrowrecovery");
    private static int tickCounter = 0;

    public void onInitialize() {
        ConfigManager.load();
        LOGGER.info("Arrow Recovery Mod initialized!");
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            String targetId;
            String projectileId;
            if (!ArrowRecoveryConfig.isModEnabled()) {
                return true;
            }
            if (entity.method_37908().method_8608()) {
                return true;
            }
            if (entity instanceof class_1657) {
                return true;
            }
            class_1297 patt0$temp = source.method_5526();
            if (!(patt0$temp instanceof class_1665)) {
                return true;
            }
            class_1665 arrow = (class_1665)patt0$temp;
            boolean isPlayer = arrow.method_24921() instanceof class_1657;
            if (!isPlayer && !ArrowRecoveryConfig.shouldAllowMobArrows()) {
                return true;
            }
            if (ArrowRecoveryConfig.hasProjectileDenyList() && ArrowRecoveryConfig.isProjectileDenied(projectileId = class_7923.field_41177.method_10221((Object)arrow.method_5864()).toString())) {
                return true;
            }
            if (ArrowRecoveryConfig.hasTargetDenyList() && ArrowRecoveryConfig.isTargetDenied(targetId = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString())) {
                return true;
            }
            ArrowHitTracker.registerHit(entity, entity.method_37908(), arrow.method_19538(), arrow);
            return true;
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, source) -> {
            if (!ArrowRecoveryConfig.isModEnabled()) {
                return;
            }
            this.dropArrowsOnDeath(entity, source);
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            if (entity instanceof class_1309 && !(entity instanceof class_1657)) {
                ArrowHitTracker.clearCount(entity.method_5667());
            }
        });
        if (ArrowRecoveryConfig.isDebugLogging()) {
            ServerTickEvents.END_SERVER_TICK.register(server -> {
                if (++tickCounter >= ArrowRecoveryConfig.getStatsIntervalTicks()) {
                    LOGGER.info("Arrow Recovery Stats: {}", (Object)ArrowHitTracker.getStats());
                    tickCounter = 0;
                }
            });
        }
    }

    private void dropArrowsOnDeath(class_1309 entity, class_1282 damageSource) {
        if (entity.method_37908().method_8608() || entity instanceof class_1657) {
            return;
        }
        ArrowHitTracker.ArrowDropData dropData = ArrowHitTracker.removeAndGetData(entity.method_5667());
        if (!dropData.hasArrows()) {
            return;
        }
        class_3218 world = (class_3218)entity.method_37908();
        double x = entity.method_23317();
        double y = entity.method_23318();
        double z = entity.method_23321();
        if (dropData.regularArrowCount > 0) {
            class_1799 arrowStack = new class_1799((class_1935)class_1802.field_8107, dropData.regularArrowCount);
            this.spawnItemWithVelocity(world, x, y, z, arrowStack);
            if (ArrowRecoveryConfig.isDebugLogging()) {
                LOGGER.debug("Dropped {} regular arrows from {}", (Object)dropData.regularArrowCount, (Object)entity.method_5667());
            }
        }
        if (!dropData.tippedArrowsWithEffect.isEmpty()) {
            HashMap<class_1844, Integer> effectGroups = new HashMap<class_1844, Integer>();
            for (class_1844 class_18442 : dropData.tippedArrowsWithEffect) {
                effectGroups.merge(class_18442, 1, Integer::sum);
            }
            for (Map.Entry entry : effectGroups.entrySet()) {
                class_1799 tippedStack = new class_1799((class_1935)class_1802.field_8087, ((Integer)entry.getValue()).intValue());
                tippedStack.method_57379(class_9334.field_49651, (Object)((class_1844)entry.getKey()));
                this.spawnItemWithVelocity(world, x, y, z, tippedStack);
            }
            if (ArrowRecoveryConfig.isDebugLogging()) {
                LOGGER.debug("Dropped {} tipped arrows from {}", (Object)dropData.tippedArrowsWithEffect.size(), (Object)entity.method_5667());
            }
        }
    }

    private void spawnItemWithVelocity(class_3218 world, double x, double y, double z, class_1799 stack) {
        class_1542 itemEntity = new class_1542((class_1937)world, x, y, z, stack);
        class_5819 random = world.field_9229;
        itemEntity.method_18800(((double)random.method_43057() - 0.5) * 0.1, 0.2, ((double)random.method_43057() - 0.5) * 0.1);
        world.method_8649((class_1297)itemEntity);
    }
}

