/*
 * Decompiled with CFR 0.152.
 */
package com.example.arrowrecovery;

import com.example.arrowrecovery.ArrowRecoveryConfig;
import com.example.arrowrecovery.ArrowRecoveryMod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("arrowrecovery.json");
    private static Config config = new Config();

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                Config loadedConfig = (Config)GSON.fromJson(json, Config.class);
                if (loadedConfig != null) {
                    config = loadedConfig;
                    ConfigManager.config.projectileDenyList = ConfigManager.config.projectileDenyList == null ? new ArrayList<String>(List.of("minecraft:trident")) : new ArrayList<String>(ConfigManager.config.projectileDenyList);
                    ConfigManager.config.targetDenyList = ConfigManager.config.targetDenyList == null ? new ArrayList<String>() : new ArrayList<String>(ConfigManager.config.targetDenyList);
                } else {
                    config = new Config();
                }
                ArrowRecoveryMod.LOGGER.info("Loaded config from {}", (Object)CONFIG_PATH);
            }
            catch (IOException e) {
                ArrowRecoveryMod.LOGGER.error("Failed to load config, using defaults", (Throwable)e);
                config = new Config();
            }
            catch (Exception e) {
                ArrowRecoveryMod.LOGGER.error("Failed to parse config JSON, using defaults", (Throwable)e);
                config = new Config();
            }
        } else {
            ConfigManager.save();
        }
        ArrowRecoveryConfig.refreshCache();
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)config);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
            ArrowRecoveryMod.LOGGER.info("Saved config to {}", (Object)CONFIG_PATH);
            ArrowRecoveryConfig.refreshCache();
        }
        catch (IOException e) {
            ArrowRecoveryMod.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static Config getConfig() {
        return config;
    }

    public static void setConfig(Config newConfig) {
        config = newConfig;
        ArrowRecoveryConfig.refreshCache();
    }

    public static class Config {
        public boolean modEnabled = true;
        public float hitChance = 0.75f;
        public int maxArrowsPerEntity = 64;
        public int maxTrackedEntities = 10000;
        public boolean debugLogging = false;
        public int statsIntervalTicks = 6000;
        public float tippedArrowEffectChance = 0.25f;
        public boolean allowMobArrows = false;
        public boolean recoverInfinityArrows = false;
        public List<String> projectileDenyList = new ArrayList<String>(List.of("minecraft:trident"));
        public List<String> targetDenyList = new ArrayList<String>();
    }
}

