/*
 * Decompiled with CFR 0.152.
 */
package com.example.arrowrecovery;

import com.example.arrowrecovery.ArrowRecoveryConfig;
import com.example.arrowrecovery.ArrowRecoveryMod;
import com.example.arrowrecovery.ConfigManager;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class ModMenuIntegration
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return this::createConfigScreen;
    }

    private class_437 createConfigScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43470((String)"Arrow Recovery Config")).setSavingRunnable(() -> {
            ConfigManager.save();
            ArrowRecoveryConfig.refreshCache();
            ArrowRecoveryMod.LOGGER.info("Config saved from in-game menu (cache refreshed)");
        });
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigManager.Config config = ConfigManager.getConfig();
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"General Settings"));
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Mod"), config.modEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"If NO, the mod stops tracking and dropping arrows")}).setSaveConsumer(value -> {
            config.modEnabled = value;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)class_2561.method_43470((String)"Arrow Recovery Chance"), config.hitChance).setDefaultValue(0.75f).setMin(0.0f).setMax(1.0f).setTooltip(new class_2561[]{class_2561.method_43470((String)"Chance for an arrow to be recoverable (0.0 = 0%, 1.0 = 100%)")}).setSaveConsumer(value -> {
            config.hitChance = value.floatValue();
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Recover Mob Arrows"), config.allowMobArrows).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"If YES, allows recovering arrows fired by mobs (skeletons, pillagers, etc.)")}).setSaveConsumer(value -> {
            config.allowMobArrows = value;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Recover Infinity Arrows"), config.recoverInfinityArrows).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"If YES, allows recovering arrows fired from Infinity bows")}).setSaveConsumer(value -> {
            config.recoverInfinityArrows = value;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43470((String)"Max Arrows Per Entity"), config.maxArrowsPerEntity).setDefaultValue(64).setMin(1).setMax(256).setTooltip(new class_2561[]{class_2561.method_43470((String)"Maximum number of arrows that can be tracked per entity")}).setSaveConsumer(value -> {
            config.maxArrowsPerEntity = value;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43470((String)"Max Tracked Entities"), config.maxTrackedEntities).setDefaultValue(10000).setMin(100).setMax(50000).setTooltip(new class_2561[]{class_2561.method_43470((String)"Maximum number of entities to track simultaneously (affects memory usage)")}).setSaveConsumer(value -> {
            config.maxTrackedEntities = value;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startStrList((class_2561)class_2561.method_43470((String)"Projectile Deny List"), config.projectileDenyList).setDefaultValue(List.of("minecraft:trident")).setTooltip(new class_2561[]{class_2561.method_43470((String)"Registry IDs of projectiles to ignore (e.g., 'minecraft:trident')")}).setSaveConsumer(value -> {
            config.projectileDenyList = value;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startStrList((class_2561)class_2561.method_43470((String)"Target Deny List"), config.targetDenyList).setDefaultValue(List.of()).setTooltip(new class_2561[]{class_2561.method_43470((String)"Entities that should NEVER drop arrows (e.g. 'minecraft:villager')")}).setSaveConsumer(value -> {
            config.targetDenyList = value;
        }).build());
        ConfigCategory tipped = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Tipped Arrows"));
        tipped.addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)class_2561.method_43470((String)"Effect Retention Chance"), config.tippedArrowEffectChance).setDefaultValue(0.25f).setMin(0.0f).setMax(1.0f).setTooltip(new class_2561[]{class_2561.method_43470((String)"Chance for tipped arrows to keep their potion effect when recovered (0.0 = 0%, 1.0 = 100%)")}).setSaveConsumer(value -> {
            config.tippedArrowEffectChance = value.floatValue();
        }).build());
        ConfigCategory debug = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Debug"));
        debug.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Debug Logging"), config.debugLogging).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Enable detailed logging for troubleshooting")}).setSaveConsumer(value -> {
            config.debugLogging = value;
        }).build());
        debug.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43470((String)"Stats Interval (ticks)"), config.statsIntervalTicks).setDefaultValue(6000).setMin(100).setMax(24000).setTooltip(new class_2561[]{class_2561.method_43470((String)"How often to log statistics when debug logging is enabled (20 ticks = 1 second)")}).setSaveConsumer(value -> {
            config.statsIntervalTicks = value;
        }).build());
        return builder.build();
    }
}

