/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.advancements.criterion;

import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesCriterias;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.CriterionValidator;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public final class CompleteHideAndSeekGameCriterion
extends SimpleCriterionTrigger<Conditions> {
    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public void trigger(ServerPlayer player, RascalEntity rascal, ItemStack stack) {
        LootContext lootContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)rascal);
        this.trigger(player, conditions -> conditions.matches(lootContext, stack));
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> rascal, Optional<ItemPredicate> item) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("rascal").forGetter(Conditions::rascal), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(Conditions::item)).apply((Applicative)instance, Conditions::new));

        public static Criterion<Conditions> any() {
            return ((CompleteHideAndSeekGameCriterion)((Object)FriendsAndFoesCriterias.COMPLETE_HIDE_AND_SEEK_GAME.get())).createCriterion((CriterionTriggerInstance)new Conditions(Optional.empty(), Optional.empty(), Optional.empty()));
        }

        public static Criterion<Conditions> create(EntityPredicate.Builder playerPredicate) {
            return ((CompleteHideAndSeekGameCriterion)((Object)FriendsAndFoesCriterias.COMPLETE_HIDE_AND_SEEK_GAME.get())).createCriterion((CriterionTriggerInstance)new Conditions(Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)playerPredicate)), Optional.empty(), Optional.empty()));
        }

        public boolean matches(LootContext rascal, ItemStack stack) {
            if (this.rascal.isPresent() && !this.rascal.get().matches(rascal)) {
                return false;
            }
            return !this.item.isPresent() || this.item.get().test(stack);
        }

        public void validate(CriterionValidator validator) {
            super.validate(validator);
            validator.validateEntity(this.rascal, ".rascal");
        }
    }
}

