/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.renderer;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.model.MaulerEntityModel;
import com.faboslav.friendsandfoes.common.client.render.entity.state.MaulerRenderState;
import com.faboslav.friendsandfoes.common.entity.MaulerEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityModelLayers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.LivingEntity;

public class MaulerEntityRenderer
extends MobRenderer<MaulerEntity, MaulerRenderState, MaulerEntityModel> {
    private static final Map<MaulerEntity.Type, Identifier> VARIANT_TEXTURE_MAP = ImmutableMap.of((Object)((Object)MaulerEntity.Type.BADLANDS), (Object)FriendsAndFoes.makeID("textures/entity/mauler/mauler_badlands.png"), (Object)((Object)MaulerEntity.Type.DESERT), (Object)FriendsAndFoes.makeID("textures/entity/mauler/mauler_desert.png"), (Object)((Object)MaulerEntity.Type.SAVANNA), (Object)FriendsAndFoes.makeID("textures/entity/mauler/mauler_savanna.png"));
    private static final float SHADOW_RADIUS = 0.35f;

    public MaulerEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MaulerEntityModel(context.bakeLayer(FriendsAndFoesEntityModelLayers.MAULER_LAYER)), 0.35f);
    }

    public MaulerRenderState createRenderState() {
        return new MaulerRenderState();
    }

    public void extractRenderState(MaulerEntity mauler, MaulerRenderState renderState, float partialTick) {
        super.extractRenderState((LivingEntity)mauler, (LivingEntityRenderState)renderState, partialTick);
        renderState.mauler = mauler;
    }

    protected float getShadowRadius(MaulerRenderState renderState) {
        MaulerEntity mauler = renderState.mauler;
        return mauler.isBurrowedDown() ? 0.0f : 0.35f;
    }

    public Identifier getTextureLocation(MaulerRenderState renderState) {
        MaulerEntity mauler = renderState.mauler;
        return VARIANT_TEXTURE_MAP.get((Object)mauler.getMaulerType());
    }
}

