/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.goal.zombiehorse;

import com.faboslav.friendsandfoes.common.entity.ZombieHorseEntityAccess;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesCriterias;
import com.faboslav.friendsandfoes.common.versions.VersionedEntity;
import com.faboslav.friendsandfoes.common.versions.VersionedEntitySpawnReason;
import java.util.List;
import net.minecraft.advancements.criterion.LightningStrikeTrigger;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.animal.equine.ZombieHorse;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public final class ZombieHorseTrapTriggerGoal
extends Goal {
    private final ZombieHorse zombieHorse;
    private Player closestPlayer;

    public ZombieHorseTrapTriggerGoal(ZombieHorse zombieHorse) {
        this.zombieHorse = zombieHorse;
    }

    public boolean canUse() {
        Player closestPlayer = this.zombieHorse.level().getNearestPlayer(this.zombieHorse.getX(), this.zombieHorse.getY(), this.zombieHorse.getZ(), 10.0, EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        if (closestPlayer == null) {
            return false;
        }
        this.closestPlayer = closestPlayer;
        return true;
    }

    public void tick() {
        ServerLevel serverWorld = (ServerLevel)this.zombieHorse.level();
        DifficultyInstance localDifficulty = serverWorld.getCurrentDifficultyAt(this.zombieHorse.blockPosition());
        ((ZombieHorseEntityAccess)this.zombieHorse).friendsandfoes_setTrapped(false);
        this.zombieHorse.setTamed(true);
        this.zombieHorse.setAge(0);
        LightningBolt lightningEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverWorld, VersionedEntitySpawnReason.TRIGGERED);
        VersionedEntity.moveTo((Entity)lightningEntity, this.zombieHorse.getX(), this.zombieHorse.getY(), this.zombieHorse.getZ());
        lightningEntity.setVisualOnly(true);
        serverWorld.addFreshEntity((Entity)lightningEntity);
        Zombie zombie = this.getZombie(localDifficulty, (AbstractHorse)this.zombieHorse);
        zombie.startRiding((Entity)this.zombieHorse);
        serverWorld.addFreshEntityWithPassengers((Entity)zombie);
        for (int i = 0; i < 3; ++i) {
            ZombieHorse zombieHorse = this.getHorse(localDifficulty);
            Zombie secondZombie = this.getZombie(localDifficulty, (AbstractHorse)zombieHorse);
            secondZombie.startRiding((Entity)zombieHorse);
            zombieHorse.push(this.zombieHorse.getRandom().triangle(0.0, 1.1485), 0.0, this.zombieHorse.getRandom().triangle(0.0, 1.1485));
            serverWorld.addFreshEntityWithPassengers((Entity)zombieHorse);
        }
        ((LightningStrikeTrigger)FriendsAndFoesCriterias.ACTIVATE_ZOMBIE_HORSE_TRAP.get()).trigger((ServerPlayer)this.closestPlayer, lightningEntity, List.of());
    }

    private ZombieHorse getHorse(DifficultyInstance localDifficulty) {
        ZombieHorse zombieHorse = (ZombieHorse)EntityType.ZOMBIE_HORSE.create(this.zombieHorse.level(), VersionedEntitySpawnReason.TRIGGERED);
        if (zombieHorse != null) {
            zombieHorse.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.zombieHorse.level()), localDifficulty, VersionedEntitySpawnReason.TRIGGERED, null);
            zombieHorse.setPos(this.zombieHorse.getX(), this.zombieHorse.getY(), this.zombieHorse.getZ());
            zombieHorse.invulnerableTime = 60;
            zombieHorse.setPersistenceRequired();
            zombieHorse.setTamed(true);
            zombieHorse.setAge(0);
        }
        return zombieHorse;
    }

    private Zombie getZombie(DifficultyInstance localDifficulty, AbstractHorse vehicle) {
        Zombie zombie = (Zombie)EntityType.ZOMBIE.create(vehicle.level(), VersionedEntitySpawnReason.TRIGGERED);
        if (zombie != null) {
            zombie.finalizeSpawn((ServerLevelAccessor)((ServerLevel)vehicle.level()), localDifficulty, VersionedEntitySpawnReason.TRIGGERED, null);
            zombie.setBaby(false);
            zombie.setPos(vehicle.getX(), vehicle.getY(), vehicle.getZ());
            zombie.invulnerableTime = 60;
            zombie.setPersistenceRequired();
            if (zombie.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                zombie.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
            }
            if (zombie.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                zombie.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.CHAINMAIL_HELMET));
            }
            this.enchantEquipment(zombie, EquipmentSlot.MAINHAND, localDifficulty);
            this.enchantEquipment(zombie, EquipmentSlot.HEAD, localDifficulty);
        }
        return zombie;
    }

    private void enchantEquipment(Zombie rider, EquipmentSlot slot, DifficultyInstance localDifficulty) {
        ItemStack itemStack = rider.getItemBySlot(slot);
        itemStack.set(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        EnchantmentHelper.enchantItemFromProvider((ItemStack)itemStack, (RegistryAccess)rider.level().registryAccess(), (ResourceKey)VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, (DifficultyInstance)localDifficulty, (RandomSource)rider.getRandom());
        rider.setItemSlot(slot, itemStack);
    }
}

