/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.animation.AnimationDefinition;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationParser;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public final class AnimationLoader
extends SimpleJsonResourceReloadListener<AnimationDefinition> {
    public static final AnimationLoader INSTANCE = new AnimationLoader();
    private Map<Identifier, AnimationHolder> animations = new MapMaker().weakValues().concurrencyLevel(1).makeMap();
    private final List<AnimationHolder> strongHolderReferences = new ArrayList<AnimationHolder>();

    private AnimationLoader() {
        super(AnimationParser.CODEC, FileToIdConverter.json((String)"friendsandfoes/animations/entity"));
    }

    public Map<Identifier, AnimationHolder> getAnimations() {
        return this.animations;
    }

    public void setAnimations(Map<Identifier, AnimationHolder> animations) {
        this.animations = animations;
    }

    @Nullable
    public AnimationDefinition getAnimation(Identifier key) {
        AnimationHolder holder = this.animations.get(key);
        return holder != null ? holder.getOrNull() : null;
    }

    public AnimationHolder getAnimationHolder(Identifier key) {
        return this.animations.computeIfAbsent(key, AnimationHolder::new);
    }

    protected void apply(Map<Identifier, AnimationDefinition> entityAnimations, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.apply(entityAnimations);
    }

    public void apply(Map<Identifier, AnimationDefinition> entityAnimations) {
        this.animations.values().forEach(AnimationHolder::unbind);
        this.strongHolderReferences.clear();
        int loaded = 0;
        for (Map.Entry<Identifier, AnimationDefinition> entry : entityAnimations.entrySet()) {
            try {
                String animationName = entry.getKey().getPath().substring(entry.getKey().getPath().lastIndexOf(47) + 1);
                AnimationHolder animationHolder = this.getAnimationHolder(entry.getKey());
                AnimationDefinition parsedAnimation = entry.getValue();
                AnimationDefinition animation = new AnimationDefinition(animationName, parsedAnimation.lengthInSeconds(), parsedAnimation.looping(), parsedAnimation.boneAnimations());
                animationHolder.bind(animation);
                this.strongHolderReferences.add(animationHolder);
                ++loaded;
            }
            catch (Exception e) {
                FriendsAndFoes.getLogger().error("Failed to load animation {}", (Object)entry.getKey(), (Object)e);
            }
        }
        FriendsAndFoes.getLogger().info("Loaded {} entity animations", (Object)loaded);
    }
}

