/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.entity.ZombieHorseEntityAccess;
import com.faboslav.friendsandfoes.common.entity.ai.goal.zombiehorse.ZombieHorseTrapTriggerGoal;
import com.faboslav.friendsandfoes.common.mixin.ZombieHorseAbstractHorseEntityMixin;
import com.faboslav.friendsandfoes.common.versions.VersionedNbt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.animal.equine.ZombieHorse;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ZombieHorse.class})
public abstract class ZombieHorseEntityMixin
extends ZombieHorseAbstractHorseEntityMixin
implements ZombieHorseEntityAccess {
    @Unique
    private final ZombieHorseTrapTriggerGoal friendsandfoes_trapTriggerGoal = new ZombieHorseTrapTriggerGoal((ZombieHorse)this);
    @Unique
    private boolean friendsandfoes_isTrapped;
    @Unique
    private int friendsandfoes_trapTime;

    protected ZombieHorseEntityMixin(EntityType<? extends AbstractHorse> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void friendsandfoes_writeCustomDataToNbt(ValueOutput nbt, CallbackInfo ci) {
        nbt.putBoolean("ZombieTrap", this.friendsandfoes_isTrapped());
        nbt.putInt("ZombieTrapTime", this.friendsandfoes_trapTime);
    }

    @Override
    public void friendsandfoes_readCustomDataFromNbt(ValueInput nbt, CallbackInfo ci) {
        this.friendsandfoes_setTrapped(VersionedNbt.getBoolean(nbt, "ZombieTrap", false));
        this.friendsandfoes_trapTime = VersionedNbt.getInt(nbt, "ZombieTrapTime", 0);
    }

    @Override
    protected void friendsandfoes_tickMovement(CallbackInfo ci) {
        if (this.friendsandfoes_isTrapped() && this.friendsandfoes_trapTime++ >= 18000) {
            this.discard();
        }
    }

    @Override
    public boolean friendsandfoes_isTrapped() {
        return this.friendsandfoes_isTrapped;
    }

    @Override
    public void friendsandfoes_setTrapped(boolean isTrapped) {
        if (isTrapped == this.friendsandfoes_isTrapped) {
            return;
        }
        this.friendsandfoes_isTrapped = isTrapped;
        if (isTrapped) {
            this.goalSelector.addGoal(1, (Goal)this.friendsandfoes_trapTriggerGoal);
        } else {
            this.goalSelector.removeGoal((Goal)this.friendsandfoes_trapTriggerGoal);
        }
    }
}

