/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.network.packet;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.animation.AnimationDefinition;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationLoader;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationParser;
import com.faboslav.friendsandfoes.common.events.lifecycle.DatapackSyncEvent;
import com.faboslav.friendsandfoes.common.network.MessageHandler;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.Identifier;

public record EntityAnimationsSyncPacket(Map<Identifier, AnimationDefinition> entityAnimations) implements Packet<EntityAnimationsSyncPacket>
{
    public static final Identifier ID = FriendsAndFoes.makeID("entity_animations_sync_packet");
    public static final ClientboundPacketType<EntityAnimationsSyncPacket> TYPE = new Handler();

    public static void sendToClient(DatapackSyncEvent event) {
        Map<Identifier, AnimationDefinition> entityAnimations = AnimationLoader.INSTANCE.getAnimations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AnimationHolder)entry.getValue()).get()));
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer((Packet)new EntityAnimationsSyncPacket(entityAnimations), event.player());
    }

    public PacketType<EntityAnimationsSyncPacket> type() {
        return TYPE;
    }

    public static class Handler
    implements ClientboundPacketType<EntityAnimationsSyncPacket> {
        public Identifier id() {
            return ID;
        }

        public Runnable handle(EntityAnimationsSyncPacket packet) {
            return () -> AnimationLoader.INSTANCE.apply(packet.entityAnimations());
        }

        public EntityAnimationsSyncPacket decode(RegistryFriendlyByteBuf buf) {
            HashMap<Identifier, AnimationDefinition> parsedEntityAnimations = new HashMap<Identifier, AnimationDefinition>();
            CompoundTag data = buf.readNbt();
            if (data == null) {
                FriendsAndFoes.getLogger().error("Entity Animation packet is empty");
                return new EntityAnimationsSyncPacket(parsedEntityAnimations);
            }
            ListTag entityAnimations = data.getListOrEmpty("entity_animations");
            for (int i = 0; i < entityAnimations.size(); ++i) {
                CompoundTag entityAnimation = entityAnimations.getCompoundOrEmpty(i);
                Tag resourceLocationTag = entityAnimation.get("resource_location");
                Tag animationDefinitionTag = entityAnimation.get("animation_definition");
                if (resourceLocationTag == null || animationDefinitionTag == null) {
                    FriendsAndFoes.getLogger().error("Entity Animation packet is invalid");
                    continue;
                }
                DataResult parsedIdentifier = Identifier.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)resourceLocationTag);
                parsedIdentifier.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to parse Resource Location packet entry: {}", (Object)error.message()));
                DataResult parsedAnimationDefinition = AnimationParser.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)animationDefinitionTag);
                parsedAnimationDefinition.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to parse Animation Definition packet entry: {}", (Object)error.message()));
                parsedIdentifier.result().ifPresent(validIdentifier -> parsedAnimationDefinition.result().ifPresent(validAnimationDefinition -> parsedEntityAnimations.put((Identifier)validIdentifier, (AnimationDefinition)validAnimationDefinition)));
            }
            return new EntityAnimationsSyncPacket(parsedEntityAnimations);
        }

        public void encode(EntityAnimationsSyncPacket packet, RegistryFriendlyByteBuf buf) {
            CompoundTag data = new CompoundTag();
            ListTag entityAnimationsList = new ListTag();
            for (Map.Entry<Identifier, AnimationDefinition> entry : packet.entityAnimations().entrySet()) {
                CompoundTag animationEntry = new CompoundTag();
                animationEntry.putString("resource_location", entry.getKey().toString());
                DataResult encodedDefinition = AnimationParser.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)entry.getValue());
                encodedDefinition.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to encode Animation Definition for {}: {}", entry.getKey(), (Object)error.message()));
                encodedDefinition.result().ifPresent(tag -> animationEntry.put("animation_definition", tag));
                entityAnimationsList.add((Object)animationEntry);
            }
            data.put("entity_animations", (Tag)entityAnimationsList);
            buf.writeNbt((Tag)data);
        }
    }
}

