/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.versions;

import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public final class VersionedNbt {
    public static String getString(ValueInput nbt, String key, String defaultValue) {
        return nbt.getStringOr(key, defaultValue);
    }

    public static int getInt(ValueInput nbt, String key, int defaultValue) {
        return nbt.getIntOr(key, defaultValue);
    }

    public static int getInt(CompoundTag nbt, String key, int defaultValue) {
        return nbt.getIntOr(key, defaultValue);
    }

    public static float getFloat(ValueInput nbt, String key, float defaultValue) {
        return nbt.getFloatOr(key, defaultValue);
    }

    public static float getFloat(CompoundTag nbt, String key, float defaultValue) {
        return nbt.getFloatOr(key, defaultValue);
    }

    public static double getDouble(ValueInput nbt, String key, double defaultValue) {
        return nbt.getDoubleOr(key, defaultValue);
    }

    public static double getDouble(CompoundTag nbt, String key, double defaultValue) {
        return nbt.getDoubleOr(key, defaultValue);
    }

    public static boolean getBoolean(ValueInput nbt, String key, boolean defaultValue) {
        return nbt.getBooleanOr(key, defaultValue);
    }

    public static CompoundTag getCompound(CompoundTag nbt, String key) {
        return nbt.getCompoundOrEmpty(key);
    }

    public static ListTag getList(CompoundTag nbt, String key) {
        return nbt.getListOrEmpty(key);
    }

    public static void putUUID(ValueOutput saveData, String key, @Nullable UUID uuid) {
        if (uuid == null) {
            return;
        }
        saveData.storeNullable(key, UUIDUtil.CODEC, (Object)uuid);
    }

    @Nullable
    public static UUID getUUID(ValueInput saveData, String key) {
        return saveData.read(key, UUIDUtil.CODEC).orElse(null);
    }
}

