/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.rascal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;

public final class RascalFindInteractionTargetTask {
    public static BehaviorControl<LivingEntity> create(int maxDistance) {
        int squaredMaxDistance = maxDistance * maxDistance;
        return BehaviorBuilder.create(context -> context.group((App)context.registered(MemoryModuleType.LOOK_TARGET), (App)context.absent(MemoryModuleType.INTERACTION_TARGET), (App)context.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)context, (lookTarget, interactionTarget, visibleMobs) -> (world, entity, time) -> {
            Optional optional = ((NearestVisibleLivingEntities)context.get(visibleMobs)).findClosest(target -> target.distanceToSqr((Entity)entity) <= (double)squaredMaxDistance && target instanceof Player && !target.isSpectator() && !((Player)target).isCreative());
            if (optional.isEmpty()) {
                return false;
            }
            LivingEntity livingEntity = (LivingEntity)optional.get();
            interactionTarget.set((Object)livingEntity);
            lookTarget.set((Object)new EntityTracker((Entity)livingEntity, true));
            return true;
        }));
    }
}

