/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.world.spawner;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.IllusionerEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.versions.VersionedEntitySpawnReason;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;

public final class IllusionerSpawner
implements CustomSpawner {
    private int cooldown;

    public void tick(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals) {
        int maxZ;
        int maxX;
        int minZ;
        if (!(spawnMonsters && FriendsAndFoes.getConfig().enableIllusioner && FriendsAndFoes.getConfig().enableIllusionerSpawn)) {
            return;
        }
        RandomSource random = world.getRandom();
        --this.cooldown;
        if (this.cooldown > 0) {
            return;
        }
        this.cooldown += 12000 + random.nextInt(1000);
        long l = world.getDayTime() / 24000L;
        if (l < 5L || world.isDarkOutside() || random.nextIntBetweenInclusive(0, 1) != 0) {
            return;
        }
        int playerCount = world.players().size();
        if (playerCount == 0) {
            return;
        }
        Player playerEntity = (Player)world.players().get(random.nextInt(playerCount));
        if (playerEntity.isSpectator() || world.isCloseToVillage(playerEntity.blockPosition(), 2)) {
            return;
        }
        int j = (24 + random.nextInt(24)) * (random.nextBoolean() ? -1 : 1);
        int k = (24 + random.nextInt(24)) * (random.nextBoolean() ? -1 : 1);
        BlockPos.MutableBlockPos mutable = playerEntity.blockPosition().mutable().move(j, 0, k);
        int minX = mutable.getX() - 10;
        if (!world.hasChunksAt(minX, minZ = mutable.getZ() - 10, maxX = mutable.getX() + 10, maxZ = mutable.getZ() + 10)) {
            return;
        }
        if (!world.getBiome((BlockPos)mutable).is(FriendsAndFoesTags.HAS_ILLUSIONER)) {
            return;
        }
        mutable.setY(world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutable).getY());
        BlockState blockState = world.getBlockState((BlockPos)mutable);
        if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)world, (BlockPos)mutable, (BlockState)blockState, (FluidState)blockState.getFluidState(), (EntityType)((EntityType)FriendsAndFoesEntityTypes.ILLUSIONER.get())) || !PatrollingMonster.checkPatrollingMonsterSpawnRules((EntityType)((EntityType)FriendsAndFoesEntityTypes.ILLUSIONER.get()), (LevelAccessor)world, (EntitySpawnReason)VersionedEntitySpawnReason.PATROL, (BlockPos)mutable, (RandomSource)random)) {
            return;
        }
        IllusionerEntity illusioner = (IllusionerEntity)((EntityType)FriendsAndFoesEntityTypes.ILLUSIONER.get()).create((Level)world, VersionedEntitySpawnReason.PATROL);
        if (illusioner == null) {
            return;
        }
        illusioner.setPatrolLeader(false);
        illusioner.findPatrolTarget();
        illusioner.setPos(mutable.getX(), mutable.getY(), mutable.getZ());
        illusioner.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt((BlockPos)mutable), VersionedEntitySpawnReason.PATROL, null);
        world.addFreshEntityWithPassengers((Entity)illusioner);
    }
}

