/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.block;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.versions.VersionedEntity;
import com.faboslav.friendsandfoes.common.versions.VersionedEntitySpawnReason;
import com.faboslav.friendsandfoes.common.versions.VersionedGameRulesProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class CrabEggBlock
extends Block {
    private static final VoxelShape SMALL_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape LARGE_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    public static final IntegerProperty EGGS = BlockStateProperties.EGGS;

    public CrabEggBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HATCH, (Comparable)Integer.valueOf(0))).setValue((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.isSteppingCarefully()) {
            this.tryBreakEgg(world, state, pos, entity, 100);
        }
        super.stepOn(world, pos, state, entity);
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!(entity instanceof Zombie)) {
            this.tryBreakEgg(world, state, pos, entity, 3);
        }
        super.fallOn(world, state, pos, entity, fallDistance);
    }

    private void tryBreakEgg(Level level, BlockState state, BlockPos pos, Entity entity, int inverseChance) {
        ServerLevel serverLevel;
        if (state.is((Block)FriendsAndFoesBlocks.CRAB_EGG.get()) && level instanceof ServerLevel && this.canBreaksEgg(serverLevel = (ServerLevel)level, entity) && level.getRandom().nextInt(inverseChance) == 0) {
            this.breakEgg(level, pos, state);
        }
    }

    private void breakEgg(Level world, BlockPos pos, BlockState state) {
        world.playSound(null, pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + world.random.nextFloat() * 0.2f);
        int i = (Integer)state.getValue((Property)EGGS);
        if (i <= 1) {
            world.destroyBlock(pos, false);
        } else {
            world.setBlock(pos, (BlockState)state.setValue((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            world.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((BlockState)state));
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.shouldHatchProgress((Level)world, pos) && CrabEggBlock.isSuitableBelow((BlockGetter)world, pos)) {
            int i = (Integer)state.getValue((Property)HATCH);
            if (i < 2) {
                world.playSound(null, pos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                world.setBlock(pos, (BlockState)state.setValue((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                world.playSound(null, pos, SoundEvents.TURTLE_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                world.removeBlock(pos, false);
                for (int j = 0; j < (Integer)state.getValue((Property)EGGS); ++j) {
                    world.levelEvent(2001, pos, Block.getId((BlockState)state));
                    CrabEntity crab = (CrabEntity)((EntityType)FriendsAndFoesEntityTypes.CRAB.get()).create((Level)world, VersionedEntitySpawnReason.BREEDING);
                    crab.setAge(-24000);
                    VersionedEntity.moveTo((Entity)crab, (double)pos.getX() + 0.3 + (double)j * 0.2, pos.getY(), (double)pos.getZ() + 0.3, 0.0f, 0.0f);
                    crab.setHome(crab.getNewHome());
                    world.addFreshEntity((Entity)crab);
                }
            }
        }
    }

    public static boolean isSuitableBelow(BlockGetter world, BlockPos pos) {
        return world.getBlockState(pos.below()).is(FriendsAndFoesTags.CRAB_BURROW_SPOT_BLOCKS);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (CrabEggBlock.isSuitableBelow((BlockGetter)world, pos) && !world.isClientSide()) {
            world.levelEvent(2005, pos, 0);
        }
    }

    private boolean shouldHatchProgress(Level world, BlockPos blockPos) {
        float f = world.getTimeOfDay(1.0f);
        return f > 0.0f && world.getRandom().nextFloat() < f;
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.playerDestroy(world, player, pos, state, blockEntity, stack);
        this.breakEgg(world, pos, state);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.isSecondaryUseActive() && context.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)EGGS) < 4 || super.canBeReplaced(state, context);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = ctx.getLevel().getBlockState(ctx.getClickedPos());
        return blockState.is((Block)this) ? (BlockState)blockState.setValue((Property)EGGS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockState.getValue((Property)EGGS) + 1))) : super.getStateForPlacement(ctx);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)EGGS) > 1 ? LARGE_SHAPE : SMALL_SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HATCH, EGGS});
    }

    private boolean canBreaksEgg(ServerLevel world, Entity entity) {
        if (!(entity instanceof CrabEntity) && !(entity instanceof Bat)) {
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            return entity instanceof Player || VersionedGameRulesProvider.getBoolean(world, VersionedGameRulesProvider.MOB_GRIEFING);
        }
        return false;
    }
}

