/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.animation.animator;

import com.faboslav.friendsandfoes.common.entity.animation.AnimationChannel;
import com.faboslav.friendsandfoes.common.entity.animation.AnimationDefinition;
import com.faboslav.friendsandfoes.common.entity.animation.animator.Keyframe;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public final class KeyframeAnimator {
    public static void animateKeyframe(EntityModel<?> model, AnimationDefinition animationDefinition, long runningTime, float scale, Vector3f vector3f, float speedModifier) {
        float g = KeyframeAnimator.getElapsedSeconds(animationDefinition, runningTime, speedModifier);
        for (Map.Entry<String, List<AnimationChannel>> entry : animationDefinition.boneAnimations().entrySet()) {
            Optional optional = model.getAnyDescendantWithName(entry.getKey());
            List<AnimationChannel> channels = entry.getValue();
            optional.ifPresent(modelPart -> channels.forEach(animationChannel -> {
                Keyframe[] keyframes = animationChannel.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)keyframes.length, ix -> g <= keyframes[ix].timestamp() * speedModifier) - 1);
                int j = Math.min(keyframes.length - 1, i + 1);
                Keyframe keyframe = keyframes[i];
                Keyframe keyframe2 = keyframes[j];
                float h = g - keyframe.timestamp() * speedModifier;
                float k = j != i ? Mth.clamp((float)(h / ((keyframe2.timestamp() - keyframe.timestamp()) * speedModifier)), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe2.interpolation().apply(vector3f, k, keyframes, i, j, scale);
                AnimationChannel.Target target = animationChannel.target();
                if (target == AnimationChannel.Target.POSITION) {
                    modelPart.offsetPos(vector3f);
                } else if (target == AnimationChannel.Target.ROTATION) {
                    modelPart.offsetRotation(vector3f);
                } else if (target == AnimationChannel.Target.SCALE) {
                    modelPart.offsetScale(vector3f);
                }
            }));
        }
    }

    private static float getElapsedSeconds(AnimationDefinition animationDefinition, long l, float speedModifier) {
        float f = (float)l / 1000.0f;
        return animationDefinition.looping() ? f % (animationDefinition.lengthInSeconds() * speedModifier) : f;
    }
}

