/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.rascal;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.advancements.criterion.CompleteHideAndSeekGameCriterion;
import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.RascalBrain;
import com.faboslav.friendsandfoes.common.entity.pose.FriendsAndFoesEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesCriterias;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public final class RascalWaitForPlayerTask
extends Behavior<RascalEntity> {
    private static final int NOD_DURATION = 90;
    public static final float NOD_RANGE = 5.0f;
    private int nodTicks;
    private LivingEntity nearestTarget;

    public RascalWaitForPlayerTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get()), (Object)MemoryStatus.VALUE_ABSENT), 90);
    }

    protected boolean checkExtraStartConditions(ServerLevel world, RascalEntity rascal) {
        if (rascal.hasCustomName()) {
            return false;
        }
        LivingEntity nearestTarget = rascal.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).orElse(null);
        if (nearestTarget == null) {
            nearestTarget = rascal.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).orElse(null);
        }
        if (nearestTarget == null || rascal.distanceTo((Entity)nearestTarget) > 5.0f || !nearestTarget.isAlive() || nearestTarget instanceof Player && (nearestTarget.isSpectator() || ((Player)nearestTarget).isCreative())) {
            return false;
        }
        this.nearestTarget = nearestTarget;
        return true;
    }

    protected void start(ServerLevel world, RascalEntity rascal, long time) {
        MovementUtil.stopMovement((Mob)rascal);
        BehaviorUtils.lookAtEntity((LivingEntity)rascal, (LivingEntity)this.nearestTarget);
        rascal.getLookControl().setLookAt((Entity)this.nearestTarget);
        rascal.getLookControl().tick();
        this.nodTicks = 0;
        rascal.addToCaughtCount();
        rascal.disableAmbientSounds();
    }

    protected boolean canStillUse(ServerLevel world, RascalEntity rascal, long time) {
        return this.nodTicks <= 90;
    }

    protected void tick(ServerLevel world, RascalEntity rascal, long time) {
        if (this.nodTicks == 20) {
            rascal.startNodAnimation();
            rascal.getLookControl().setLookAt((Entity)this.nearestTarget);
        }
        if (this.nodTicks == 40 && rascal.shouldGiveReward()) {
            rascal.startGiveRewardAnimation();
        }
        if (this.nodTicks == 62 && rascal.shouldGiveReward()) {
            Vec3 targetPos = this.nearestTarget.position().add(0.0, 1.0, 0.0);
            LootTable rascalGoodItemsLootTable = world.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)FriendsAndFoes.makeID("rewards/rascal_good_reward")));
            LootParams lootContextParameterSet = new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, (Object)targetPos).withParameter(LootContextParams.THIS_ENTITY, (Object)this.nearestTarget).create(LootContextParamSets.GIFT);
            ObjectArrayList rascalGoodRewards = rascalGoodItemsLootTable.getRandomItems(lootContextParameterSet);
            for (ItemStack rascalReward : rascalGoodRewards) {
                ItemStack bundleItemStack = Items.BUNDLE.getDefaultInstance();
                BundleContents bundleContentsComponent = (BundleContents)bundleItemStack.get(DataComponents.BUNDLE_CONTENTS);
                if (bundleContentsComponent == null) break;
                BundleContents.Mutable builder = new BundleContents.Mutable(bundleContentsComponent);
                builder.tryInsert(rascalReward);
                bundleItemStack.set(DataComponents.BUNDLE_CONTENTS, (Object)builder.toImmutable());
                BehaviorUtils.throwItem((LivingEntity)rascal, (ItemStack)bundleItemStack, (Vec3)this.nearestTarget.position().add(0.0, 1.0, 0.0));
                ((CompleteHideAndSeekGameCriterion)((Object)FriendsAndFoesCriterias.COMPLETE_HIDE_AND_SEEK_GAME.get())).trigger((ServerPlayer)this.nearestTarget, rascal, bundleItemStack);
            }
        }
        ++this.nodTicks;
    }

    protected void stop(ServerLevel world, RascalEntity rascal, long time) {
        if (!rascal.hasCustomName()) {
            rascal.spawnCloudParticles();
            rascal.playDisappearSound();
            if (rascal.shouldGiveReward()) {
                rascal.discard();
                return;
            }
            rascal.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 200));
            this.tryToTeleport(world, rascal);
        }
        rascal.setEntityPose(FriendsAndFoesEntityPose.IDLE);
        RascalBrain.setNodCooldown(rascal);
        rascal.enableAmbientSounds();
    }

    private void tryToTeleport(ServerLevel world, RascalEntity rascal) {
        StructureManager structureAccessor = world.structureManager();
        int worldBottomY = world.getMinY();
        int logicalHeight = world.getLogicalHeight();
        for (int i = 0; i < 64; ++i) {
            boolean teleportResult;
            double z;
            double y;
            double x = rascal.getX() + (rascal.getRandom().nextDouble() - 0.5) * 16.0;
            if (!structureAccessor.getStructureWithPieceAt(new BlockPos((int)x, (int)(y = Mth.clamp((double)(rascal.getY() + (double)(rascal.getRandom().nextInt(8) - 4)), (double)worldBottomY, (double)(worldBottomY + logicalHeight - 1))), (int)(z = rascal.getZ() + (rascal.getRandom().nextDouble() - 0.5) * 16.0)), StructureTags.MINESHAFT).isValid()) continue;
            if (rascal.isPassenger()) {
                rascal.stopRiding();
            }
            if (!(teleportResult = rascal.randomTeleport(x, y, z, false)) || !((double)rascal.distanceTo((Entity)this.nearestTarget) > 10.0)) continue;
            return;
        }
    }
}

