/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.faboslav.friendsandfoes.common.versions.VersionedEntitySpawnReason;
import com.faboslav.friendsandfoes.common.versions.VersionedNbt;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public final class PlayerIllusionEntity
extends class_1308 {
    private static final String TICKS_UNTIL_DESPAWN_NBT_NAME = "TicksUntilDespawn";
    private static final class_2940<Integer> TICKS_UNTIL_DESPAWN = class_2945.method_12791(PlayerIllusionEntity.class, (class_2941)class_2943.field_13327);
    private static final String PLAYER_UUID_NBT_NAME = "PlayerUuid";
    private static final class_2940<Byte> PLAYER_MODEL_PARTS = class_2945.method_12791(PlayerIllusionEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Optional<UUID>> PLAYER_UUID = class_2945.method_12791(PlayerIllusionEntity.class, (class_2941)class_2943.field_13313);
    @Nullable
    private class_1657 player;
    public double prevCapeX;
    public double prevCapeY;
    public double prevCapeZ;
    public double capeX;
    public double capeY;
    public double capeZ;
    public float prevStrideDistance;
    public float strideDistance;

    public PlayerIllusionEntity(class_1299<? extends class_1308> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (spawnReason == VersionedEntitySpawnReason.COMMAND) {
            class_1657 player;
            this.setTicksUntilDespawn(-1);
            if (this.getPlayerUuid() == null && (player = this.method_37908().method_8604(this.method_23317(), this.method_23318(), this.method_23321(), 10.0, null)) != null) {
                this.setPlayer(player);
                this.setPlayerUuid(player.method_5667());
            }
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public static class_5132.class_5133 createPlayerIllusionAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(PLAYER_MODEL_PARTS, (Object)0);
        builder.method_56912(TICKS_UNTIL_DESPAWN, (Object)0);
        builder.method_56912(PLAYER_UUID, Optional.empty());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569(TICKS_UNTIL_DESPAWN_NBT_NAME, this.getTicksUntilDespawn());
        VersionedNbt.putUUID(nbt, PLAYER_UUID_NBT_NAME, this.getPlayerUuid());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setPlayerUuid(VersionedNbt.getUUID(nbt, PLAYER_UUID_NBT_NAME));
        this.setTicksUntilDespawn(VersionedNbt.getInt(nbt, TICKS_UNTIL_DESPAWN_NBT_NAME, 0));
    }

    public boolean method_6054() {
        return false;
    }

    protected boolean method_27071() {
        return false;
    }

    public boolean method_5733() {
        return false;
    }

    public void method_6007() {
        boolean isPlayerNonExistingOrDead;
        super.method_6007();
        if (this.getTicksUntilDespawn() > 0) {
            this.setTicksUntilDespawn(this.getTicksUntilDespawn() - 1);
        }
        boolean bl = isPlayerNonExistingOrDead = this.getPlayer() != null && !this.getPlayer().method_5805();
        if (this.getTicksUntilDespawn() == 0 || isPlayerNonExistingOrDead) {
            this.discardIllusion();
        }
    }

    public boolean method_64397(class_3218 level, class_1282 damageSource, float amount) {
        this.discardIllusion();
        return true;
    }

    public boolean isPartVisible(class_1664 modelPart) {
        return ((Byte)this.method_5841().method_12789(PLAYER_MODEL_PARTS) & modelPart.method_7430()) == modelPart.method_7430();
    }

    @Nullable
    public UUID getPlayerUuid() {
        return ((Optional)this.field_6011.method_12789(PLAYER_UUID)).orElse(null);
    }

    public void setPlayerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(PLAYER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public class_1657 getPlayer() {
        return this.player;
    }

    public void setPlayer(class_1657 player) {
        this.player = player;
    }

    public int getTicksUntilDespawn() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_DESPAWN);
    }

    public void setTicksUntilDespawn(int ticksUntilDespawn) {
        this.field_6011.method_12778(TICKS_UNTIL_DESPAWN, (Object)ticksUntilDespawn);
    }

    private void discardIllusion() {
        this.playMirrorSound();
        ParticleSpawner.spawnParticles((class_1309)this, (class_2394)class_2398.field_11204, 16, 0.1);
        this.method_31472();
    }

    private void playMirrorSound() {
        this.method_5783((class_3414)FriendsAndFoesSoundEvents.ENTITY_PLAYER_MIRROR_MOVE.get(), this.method_6107(), this.method_6017());
    }
}

