/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.versions.VersionedEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;

public final class GlareTeleportToOwnerTask
extends Behavior<GlareEntity> {
    private LivingEntity owner;

    public GlareTeleportToOwnerTask() {
        super((Map)ImmutableMap.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel world, GlareEntity glare) {
        LivingEntity owner = glare.getOwner();
        return owner != null && !owner.isSpectator() && !glare.isLeashed() && !glare.isOrderedToSit() && !glare.isPassenger() && !(glare.distanceToSqr((Entity)owner) < 1024.0);
    }

    protected void start(ServerLevel world, GlareEntity glare, long time) {
        this.owner = glare.getOwner();
        this.tryTeleport(glare);
    }

    private void tryTeleport(GlareEntity glare) {
        BlockPos blockPos = this.owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int xOffset = this.getRandomInt(glare, -3, 3);
            int yOffset = this.getRandomInt(glare, -1, 1);
            int zOffset = this.getRandomInt(glare, -3, 3);
            boolean teleportResult = this.tryTeleportTo(glare, blockPos.getX() + xOffset, blockPos.getY() + yOffset, blockPos.getZ() + zOffset);
            if (!teleportResult) continue;
            return;
        }
    }

    private boolean tryTeleportTo(GlareEntity glare, int x, int y, int z) {
        if (Math.abs((double)x - this.owner.getX()) < 2.0 && Math.abs((double)z - this.owner.getZ()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(glare, new BlockPos(x, y, z))) {
            return false;
        }
        VersionedEntity.moveTo((Entity)glare, (double)x + 0.5, y, (double)z + 0.5, glare.getYRot(), glare.getXRot());
        glare.getNavigation().stop();
        return true;
    }

    private boolean canTeleportTo(GlareEntity glare, BlockPos pos) {
        BlockPos blockPos = pos.subtract((Vec3i)glare.blockPosition());
        return glare.level().noCollision((Entity)glare, glare.getBoundingBox().move(blockPos));
    }

    private int getRandomInt(GlareEntity glare, int min, int max) {
        return glare.getRandom().nextInt(max - min + 1) + min;
    }
}

