/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.util.Rect2i;

public class CroppedImage
implements Image {
    private final Image original;
    private final Rect2i crop;

    public CroppedImage(Image original, Rect2i crop) {
        Preconditions.checkArgument((crop.getX() >= 0 && crop.getY() >= 0 && crop.getX() + crop.getWidth() <= original.width() && crop.getY() + crop.getHeight() <= original.height() ? 1 : 0) != 0, (String)"%s is out of bounds for image size {%s, %s}", (Object)crop, (Object)original.width(), (Object)original.height());
        this.original = original;
        this.crop = crop;
    }

    @Override
    public int width() {
        return this.crop.getWidth();
    }

    @Override
    public int height() {
        return this.crop.getHeight();
    }

    @Override
    public int getPixelARGB(int x, int y) {
        return this.original.getPixelARGB(this.crop.getX() + x, this.crop.getY() + y);
    }

    @Override
    public void close() {
        this.original.close();
    }
}

