/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.EmptyImage;
import io.github.mortuusars.exposure.client.image.MissingImage;

public interface Image
extends AutoCloseable {
    public static final Image EMPTY = new EmptyImage();
    public static final Image MISSING = new MissingImage();

    public int width();

    public int height();

    public int getPixelARGB(int var1, int var2);

    @Override
    default public void close() {
    }

    default public boolean isEmpty() {
        return this.equals(EMPTY) || this.width() <= 1 && this.height() <= 1 && this.getPixelARGB(0, 0) == 0;
    }

    public static void validate(int width, int height, int pixelCount) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (String)"Width should be larger than 0. %s", (int)width);
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (String)"Height should be larger than 0. %s ", (int)height);
        Preconditions.checkArgument((pixelCount == width * height ? 1 : 0) != 0, (String)"Pixel count '%s' is not correct for image dimensions of '%sx%s'. Count should be '%s'.", (Object)pixelCount, (Object)width, (Object)height, (Object)(width * height));
    }

    public static abstract class Wrapped
    implements Image {
        private final Image image;

        public Wrapped(Image image) {
            this.image = image;
        }

        public Image getImage() {
            return this.image;
        }

        @Override
        public int width() {
            return this.image.width();
        }

        @Override
        public int height() {
            return this.image.height();
        }

        @Override
        public int getPixelARGB(int x, int y) {
            return this.image.getPixelARGB(x, y);
        }

        @Override
        public void close() {
            this.image.close();
        }

        @Override
        public boolean isEmpty() {
            return this.getImage().isEmpty();
        }
    }
}

