/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import java.util.Random;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class NoiseEffect
implements PixelEffect {
    protected final Random random = new Random();
    protected final float intensity;

    public NoiseEffect(float intensity) {
        Preconditions.checkArgument((intensity >= 0.0f && intensity <= 1.0f ? 1 : 0) != 0, (Object)"intensity should be in 0-1 range.");
        this.intensity = intensity;
    }

    @Override
    public String getIdentifier() {
        return "noise-" + this.intensity;
    }

    @Override
    public int modify(int colorARGB) {
        int alpha = FastColor.ARGB32.alpha((int)colorARGB);
        int red = FastColor.ARGB32.red((int)colorARGB);
        int green = FastColor.ARGB32.green((int)colorARGB);
        int blue = FastColor.ARGB32.blue((int)colorARGB);
        float brightness = (0.299f * (float)red + 0.587f * (float)green + 0.114f * (float)blue) / 255.0f;
        float intensity = this.intensity * (1.0f - brightness);
        intensity = Mth.lerp((float)0.25f, (float)intensity, (float)this.intensity);
        int noise = (int)(this.random.nextGaussian() * (double)intensity * 155.0);
        int rNoise = (int)(this.random.nextGaussian() * (double)intensity * 100.0);
        int gNoise = (int)(this.random.nextGaussian() * (double)intensity * 100.0);
        int bNoise = (int)(this.random.nextGaussian() * (double)intensity * 100.0);
        red = Mth.clamp((int)(red + noise + rNoise), (int)0, (int)255);
        green = Mth.clamp((int)(green + noise + gNoise), (int)0, (int)255);
        blue = Mth.clamp((int)(blue + noise + bNoise), (int)0, (int)255);
        return FastColor.ARGB32.color((int)alpha, (int)red, (int)green, (int)blue);
    }
}

