/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.block;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.world.block.entity.LightroomBlockEntity;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty PRINTING = BooleanProperty.create((String)"printing");
    public static final BooleanProperty REFRACTED = BooleanProperty.create((String)"refracted");

    public LightroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)PRINTING, (Comparable)Boolean.valueOf(false))).setValue((Property)REFRACTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, PRINTING, REFRACTED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    public void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof LightroomBlockEntity) {
                LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Containers.dropContents((Level)serverLevel, (BlockPos)pos, (Container)lightroomBlockEntity);
                    lightroomBlockEntity.dropStoredExperience(null);
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState blockState, Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LightroomBlockEntity) {
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
            ItemStack resultStack = lightroomBlockEntity.getItem(6);
            Item item = resultStack.getItem();
            if (item instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)item;
                int photographsCount = stackedPhotographsItem.getPhotographs(resultStack).size();
                return (int)((float)photographsCount / (float)stackedPhotographsItem.getStackLimit() * 14.0f + 1.0f);
            }
            if (!resultStack.isEmpty()) {
                return 1;
            }
        }
        return 0;
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof LightroomBlockEntity)) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
        player.awardStat(Exposure.Stats.INTERACT_WITH_LIGHTROOM);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            lightroomBlockEntity.setLastPlayer((Player)serverPlayer);
            lightroomBlockEntity.setChanged();
            PlatformHelper.openMenu(serverPlayer, (MenuProvider)lightroomBlockEntity, buffer -> buffer.writeBlockPos(pos));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void neighborChanged(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean pIsMoving) {
        if (!level.isClientSide) {
            if (!((Boolean)state.getValue((Property)PRINTING)).booleanValue()) {
                for (Direction direction : Direction.values()) {
                    BlockEntity blockEntity;
                    BlockPos relative = pos.relative(direction);
                    if (!relative.equals((Object)fromPos) || level.getSignal(relative, direction) <= 0 || !((blockEntity = level.getBlockEntity(pos)) instanceof LightroomBlockEntity)) continue;
                    LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
                    lightroomBlockEntity.startPrintingProcess(true);
                    break;
                }
            }
            level.setBlock(pos, (BlockState)level.getBlockState(pos).setValue((Property)REFRACTED, (Comparable)Boolean.valueOf(level.getBlockState(pos.above()).is(Exposure.Tags.Blocks.CHROMATIC_REFRACTORS))), 2);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return LightroomBlock.createBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return LightroomBlock.getBlockTicker(level, state, blockEntityType);
    }

    public static BlockEntity createBlockEntity(BlockPos pos, BlockState state) {
        return new LightroomBlockEntity(pos, state);
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getBlockTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!level.isClientSide && blockEntityType.equals(Exposure.BlockEntityTypes.LIGHTROOM.get())) {
            return LightroomBlockEntity::serverTick;
        }
        return null;
    }
}

