/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera;

import com.mojang.serialization.Codec;
import io.github.mortuusars.exposure.Exposure;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record CameraId(UUID uuid) {
    public static final Codec<CameraId> CODEC = UUIDUtil.CODEC.xmap(CameraId::new, CameraId::uuid);
    public static final StreamCodec<ByteBuf, CameraId> STREAM_CODEC = UUIDUtil.STREAM_CODEC.map(CameraId::new, CameraId::uuid);

    public static CameraId create() {
        return new CameraId(UUID.randomUUID());
    }

    public static CameraId ofStack(ItemStack stack) {
        return (CameraId)stack.getOrDefault(Exposure.DataComponents.CAMERA_ID, (Object)new CameraId(Util.NIL_UUID));
    }

    public boolean matches(ItemStack stack) {
        return this.equals(stack.get(Exposure.DataComponents.CAMERA_ID));
    }

    @Override
    public String toString() {
        return this.uuid().toString();
    }
}

