/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.capture;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum DitherMode implements StringRepresentable
{
    DITHERED("dithered"),
    CLEAN("clean");

    private static final IntFunction<DitherMode> BY_ID;
    public static final Codec<DitherMode> CODEC;
    public static final StreamCodec<ByteBuf, DitherMode> STREAM_CODEC;
    private final String name;

    private DitherMode(String name) {
        this.name = name;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public Component translate() {
        return Component.translatable((String)("item.exposure.interplanar_projector.mode." + this.getSerializedName()));
    }

    public DitherMode cycle() {
        return BY_ID.apply(this.ordinal() + 1);
    }

    static {
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])DitherMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        CODEC = StringRepresentable.fromEnum(DitherMode::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

