/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum SelfTimer implements StringRepresentable
{
    OFF("off", 0),
    ONE("one", 1),
    TWO("two", 2),
    FIVE("five", 5),
    TEN("ten", 10);

    public static final Codec<SelfTimer> CODEC;
    public static final StreamCodec<ByteBuf, SelfTimer> STREAM_CODEC;
    private final String name;
    private final int seconds;

    private SelfTimer(String name, int seconds) {
        this.name = name;
        this.seconds = seconds;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getTicks() {
        return this.seconds * 20;
    }

    public MutableComponent translate() {
        return Component.translatable((String)("gui.exposure.self_timer." + this.name));
    }

    static {
        CODEC = StringRepresentable.fromEnum(SelfTimer::values);
        STREAM_CODEC = ByteBufCodecs.idMapper((IntFunction)ByIdMap.continuous(Enum::ordinal, (Object[])SelfTimer.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO), Enum::ordinal);
    }
}

