/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.frame;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.util.ExtraData;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public record EntityInFrame(ResourceLocation id, String name, BlockPos pos, int distance, ExtraData extraData) {
    public static Codec<EntityInFrame> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(EntityInFrame::id), (App)Codec.STRING.optionalFieldOf("name", (Object)"").forGetter(EntityInFrame::name), (App)BlockPos.CODEC.fieldOf("pos").forGetter(EntityInFrame::pos), (App)Codec.INT.optionalFieldOf("distance", (Object)Integer.MAX_VALUE).forGetter(EntityInFrame::distance), (App)ExtraData.CODEC.optionalFieldOf("extra_data", (Object)ExtraData.EMPTY).forGetter(EntityInFrame::extraData)).apply((Applicative)instance, EntityInFrame::new));
    public static StreamCodec<FriendlyByteBuf, EntityInFrame> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, EntityInFrame::id, (StreamCodec)ByteBufCodecs.STRING_UTF8, EntityInFrame::name, (StreamCodec)BlockPos.STREAM_CODEC, EntityInFrame::pos, (StreamCodec)ByteBufCodecs.VAR_INT, EntityInFrame::distance, ExtraData.STREAM_CODEC, EntityInFrame::extraData, EntityInFrame::new);

    public static EntityInFrame of(Entity cameraHolder, Entity entity) {
        return EntityInFrame.of(cameraHolder, entity, ExtraData.EMPTY);
    }

    public static EntityInFrame of(Entity cameraHolder, Entity entity, Consumer<ExtraData> data) {
        ExtraData extraData = new ExtraData();
        data.accept(extraData);
        return EntityInFrame.of(cameraHolder, entity, extraData);
    }

    public static EntityInFrame of(Entity cameraHolder, Entity entity, ExtraData extraData) {
        ResourceLocation key = EntityType.getKey((EntityType)entity.getType());
        String name = entity.getName().getString();
        int distance = (int)cameraHolder.distanceTo(entity);
        return new EntityInFrame(key, name, entity.blockPosition(), distance, extraData);
    }
}

