/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public interface FilmItem {
    public ExposureType getType();

    default public int getDefaultMaxFrameCount(ItemStack stack) {
        return 16;
    }

    default public int getDefaultFrameSize(ItemStack stack) {
        return (Integer)Config.Server.DEFAULT_FRAME_SIZE.get();
    }

    default public int getMaxFrameCount(ItemStack stack) {
        return (Integer)stack.getOrDefault(Exposure.DataComponents.FILM_FRAME_COUNT, (Object)this.getDefaultMaxFrameCount(stack));
    }

    default public int getFrameSize(ItemStack stack) {
        return (Integer)stack.getOrDefault(Exposure.DataComponents.FILM_FRAME_SIZE, (Object)this.getDefaultFrameSize(stack));
    }

    default public List<Frame> getStoredFrames(ItemStack stack) {
        return (List)stack.getOrDefault(Exposure.DataComponents.FILM_FRAMES, Collections.emptyList());
    }

    default public int getStoredFramesCount(ItemStack stack) {
        return this.getStoredFrames(stack).size();
    }

    default public boolean hasFrames(ItemStack stack) {
        return !this.getStoredFrames(stack).isEmpty();
    }

    default public boolean hasFrameAt(ItemStack stack, int index) {
        return this.getStoredFrames(stack).size() > index;
    }

    default public float getFullness(ItemStack stack) {
        return (float)this.getStoredFramesCount(stack) / (float)this.getMaxFrameCount(stack);
    }

    default public boolean isFull(ItemStack stack) {
        return this.getStoredFramesCount(stack) == this.getMaxFrameCount(stack);
    }
}

