/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.client.gui.ClientGUI;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.inventory.tooltip.PhotographTooltip;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import io.github.mortuusars.exposure.world.photograph.PhotographType;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographItem
extends Item {
    public PhotographItem(Item.Properties properties) {
        super(properties);
    }

    public PhotographType getType(ItemStack stack) {
        return PhotographType.REGULAR;
    }

    public Frame getFrame(ItemStack stack) {
        return (Frame)stack.getOrDefault(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)Frame.EMPTY);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        ExposureIdentifier identifier = this.getFrame(stack).identifier();
        return !identifier.isEmpty() ? Optional.of(new PhotographTooltip(List.of(new ItemAndStack(stack)))) : Optional.empty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        Frame frame;
        @Nullable Integer generation = (Integer)stack.get(Exposure.DataComponents.PHOTOGRAPH_GENERATION);
        if (generation != null && generation > 0) {
            tooltipComponents.add((Component)Component.translatable((String)("item.exposure.photograph.generation." + generation)).withStyle(ChatFormatting.GRAY));
        }
        if ((frame = (Frame)stack.get(Exposure.DataComponents.PHOTOGRAPH_FRAME)) == null) {
            return;
        }
        String photographerName = frame.photographer().name();
        if (((Boolean)Config.Client.PHOTOGRAPH_SHOW_PHOTOGRAPHER_IN_TOOLTIP.get()).booleanValue() && !photographerName.isEmpty()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.exposure.photograph.photographer_tooltip", (Object[])new Object[]{Component.literal((String)photographerName).withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.GRAY));
        }
        if (((Boolean)Config.Client.RECIPE_TOOLTIPS_WITHOUT_JEI.get()).booleanValue()) {
            boolean jeiLoaded = PlatformHelper.isModLoaded("jei");
            if (!(generation != null && generation >= 2 || jeiLoaded)) {
                ClientGUI.addPhotographCopyingTooltip(stack, context, tooltipComponents, tooltipFlag);
            }
        }
        if (tooltipFlag.isAdvanced()) {
            String identifier = frame.identifier().map(id -> "Id: " + id, texture -> "Texture: " + String.valueOf(texture));
            tooltipComponents.add((Component)Component.literal((String)identifier).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        Frame frame = this.getFrame(itemInHand);
        if (frame == Frame.EMPTY || frame.identifier().isEmpty()) {
            return InteractionResultHolder.pass((Object)itemInHand);
        }
        if (level.isClientSide) {
            int slot = hand == InteractionHand.OFF_HAND ? 40 : player.getInventory().selected;
            ClientGUI.openPhotographsScreenFromItem(slot);
            player.playSound(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, 1.1f);
        }
        return InteractionResultHolder.success((Object)itemInHand);
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (other.getItem() instanceof PhotographItem) {
            StackedPhotographsItem stackedPhotographsItem = Exposure.Items.STACKED_PHOTOGRAPHS.get();
            ItemStack stackedPhotographsStack = new ItemStack((ItemLike)stackedPhotographsItem);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, stack);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, other);
            slot.set(stackedPhotographsStack);
            access.set(ItemStack.EMPTY);
            StackedPhotographsItem.playAddSoundClientside(player);
            return true;
        }
        return false;
    }
}

