/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.crafting.recipe;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.item.crafting.recipe.ComponentTransferringRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class PhotographAgingRecipe
extends ComponentTransferringRecipe {
    public PhotographAgingRecipe(CraftingBookCategory category, Ingredient sourceIngredient, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(category, sourceIngredient, ingredients, result);
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Exposure.RecipeSerializers.PHOTOGRAPH_AGING.get();
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remainingItems = super.getRemainingItems((RecipeInput)input);
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (!(stack.getItem() instanceof BrushItem)) continue;
            stack = stack.copy();
            int damage = stack.getDamageValue() + 1;
            stack.setDamageValue(damage);
            if (damage >= stack.getMaxDamage()) {
                stack.shrink(1);
            }
            remainingItems.set(i, (Object)stack);
        }
        return remainingItems;
    }
}

