/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.template;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplate;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CaptureTemplates {
    private static final Map<class_2960, CaptureTemplate> TEMPLATES = new HashMap<class_2960, CaptureTemplate>();

    public static void register(class_2960 id, CaptureTemplate template) {
        Preconditions.checkState((!TEMPLATES.containsKey(id) ? 1 : 0) != 0, (String)"Template with id '%s' is already registered.", (Object)id);
        TEMPLATES.put(id, template);
    }

    @Nullable
    public static CaptureTemplate get(class_2960 id) {
        return TEMPLATES.get(id);
    }

    public static CaptureTemplate getOrThrow(class_2960 id) {
        @Nullable CaptureTemplate template = TEMPLATES.get(id);
        Preconditions.checkNotNull((Object)template, (String)"No template for id '%s' is registered.", (Object)id);
        return template;
    }
}

