/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.album;

import com.google.common.collect.Lists;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.gui.screen.album.ChildPhotographScreen;
import io.github.mortuusars.exposure.client.render.photograph.PhotographStyle;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8001;
import net.minecraft.class_8494;
import net.minecraft.class_8666;

public class PhotographSlotWidget
extends class_339 {
    public static final class_8666 SPRITES = new class_8666(Exposure.resource("album/photograph_slot"), Exposure.resource("album/photograph_slot_highlighted"));
    public static final class_8666 EMPTY_SPRITES = new class_8666(Exposure.resource("album/photograph_slot_empty"), Exposure.resource("album/photograph_slot_empty_highlighted"));
    private final class_437 parent;
    protected final Supplier<class_1799> photographSupplier;
    protected boolean editable;
    protected Consumer<PhotographSlotWidget> primaryAction = slot -> {};
    protected Consumer<PhotographSlotWidget> secondaryAction = slot -> {};
    protected boolean hasPhotograph;

    public PhotographSlotWidget(class_437 parent, int x, int y, int width, int height, Supplier<class_1799> photographSupplier) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.parent = parent;
        this.photographSupplier = photographSupplier;
    }

    public PhotographSlotWidget editable(boolean editable) {
        this.editable = editable;
        return this;
    }

    public PhotographSlotWidget primaryAction(Consumer<PhotographSlotWidget> primaryAction) {
        this.primaryAction = primaryAction;
        return this;
    }

    public PhotographSlotWidget secondaryAction(Consumer<PhotographSlotWidget> secondaryAction) {
        this.secondaryAction = secondaryAction;
        return this;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public class_1799 getPhotograph() {
        return this.photographSupplier.get();
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_1799 photograph = this.getPhotograph();
        if (photograph.method_7909() instanceof PhotographItem) {
            this.hasPhotograph = true;
            PhotographStyle photographStyle = PhotographStyle.of(photograph);
            guiGraphics.method_25291(photographStyle.albumPaperTexture(), this.method_46426(), this.method_46427(), 0, 0.0f, 0.0f, this.field_22758, this.field_22759, this.field_22758, this.field_22759);
            guiGraphics.method_51448().method_22903();
            float scale = 96.0f;
            guiGraphics.method_51448().method_46416((float)(this.method_46426() + 6), (float)(this.method_46427() + 6), 1.0f);
            guiGraphics.method_51448().method_22905(scale, scale, scale);
            class_4597.class_4598 bufferSource = Minecrft.get().method_22940().method_23000();
            ExposureClient.photographRenderer().render(photograph, false, false, guiGraphics.method_51448(), (class_4597)bufferSource, 0xF000F0);
            bufferSource.method_22993();
            guiGraphics.method_51448().method_22909();
            if (photographStyle.hasAlbumOverlayTexture()) {
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416(0.0f, 0.0f, 2.0f);
                guiGraphics.method_25291(photographStyle.albumOverlayTexture(), this.method_46426(), this.method_46427(), 0, 0.0f, 0.0f, this.field_22758, this.field_22759, this.field_22758, this.field_22759);
                guiGraphics.method_51448().method_22909();
            }
        } else {
            this.hasPhotograph = false;
        }
        class_8666 sprites = this.hasPhotograph ? SPRITES : EMPTY_SPRITES;
        class_2960 resourceLocation = sprites.method_52729(this.method_37303(), this.method_25367());
        if (!this.editable && !this.hasPhotograph) {
            resourceLocation = sprites.method_52729(this.method_37303(), false);
        }
        guiGraphics.method_52706(resourceLocation, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
    }

    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.editable && !this.hasPhotograph) {
            guiGraphics.method_51438(Minecrft.get().field_1772, (class_2561)class_2561.method_43471((String)"gui.exposure.album.add_photograph"), mouseX, mouseY);
            return;
        }
        class_1799 photograph = this.getPhotograph();
        if (photograph.method_7960()) {
            return;
        }
        List itemTooltip = class_437.method_25408((class_310)Minecrft.get(), (class_1799)photograph);
        itemTooltip.add(class_2561.method_43471((String)"gui.exposure.album.left_click_or_scroll_up_to_view"));
        if (this.editable) {
            itemTooltip.add(class_2561.method_43471((String)"gui.exposure.album.right_click_to_remove"));
        }
        if (this.method_25370()) {
            guiGraphics.method_51436(Minecrft.get().field_1772, Lists.transform((List)itemTooltip, class_2561::method_30937), class_8001.field_41687, mouseX, mouseY);
        } else {
            guiGraphics.method_51437(Minecrft.get().field_1772, itemTooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!(this.field_22763 && this.field_22764 && this.method_25361(mouseX, mouseY))) {
            return false;
        }
        if (button == 0) {
            this.primaryAction.accept(this);
        } else if (button == 1) {
            this.secondaryAction.accept(this);
        } else {
            return false;
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY > 0.0 && this.method_25361(mouseX, mouseY) && this.hasPhotograph) {
            this.primaryAction.accept(this);
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22763 && this.field_22764 && class_8494.method_51255((int)keyCode)) {
            if (class_437.method_25442()) {
                this.secondaryAction.accept(this);
            } else {
                this.primaryAction.accept(this);
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        class_1799 photograph = this.getPhotograph();
        if (!photograph.method_7960()) {
            narrationElementOutput.method_37034(class_6381.field_33788, photograph.method_7964());
        }
    }

    public boolean inspectPhotograph() {
        class_1799 photograph = this.getPhotograph();
        if (!(photograph.method_7909() instanceof PhotographItem)) {
            return false;
        }
        Minecrft.get().method_1507((class_437)new ChildPhotographScreen(this.parent, List.of(new ItemAndStack(photograph))));
        Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), (float)(Minecrft.level().method_8409().method_43057() * 0.2f + 1.3f), (float)0.75f));
        return true;
    }
}

