/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.test;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.exposure.client.util.Minecrft;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8015;
import net.minecraft.class_8494;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class Slider
extends class_339 {
    public static final class_2960 SLIDER_SPRITE = class_2960.method_60656((String)"widget/slider");
    public static final class_2960 HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"widget/slider_highlighted");
    public static final class_2960 SLIDER_HANDLE_SPRITE = class_2960.method_60656((String)"widget/slider_handle");
    public static final class_2960 SLIDER_HANDLE_HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"widget/slider_handle_highlighted");
    protected static final int TEXT_MARGIN = 2;
    protected static final int HANDLE_WIDTH = 8;
    protected static final int HANDLE_HALF_WIDTH = 4;
    protected double position;
    protected boolean canChangeValue;
    protected final double defaultValue;
    protected final double min;
    protected final double max;
    protected final DecimalFormat displayFormat;
    protected final String name;
    protected final Consumer<Double> onChanged;
    @Nullable
    protected Pair<Integer, Integer> horizontalGradient;

    public Slider(int x, int y, int width, int height, double defaultValue, double min, double max, int displayedPrecision, String name, Consumer<Double> onChanged) {
        this(x, y, width, height, class_5244.field_39003, defaultValue, min, max, displayedPrecision, name, onChanged);
    }

    public Slider(int x, int y, int width, int height, class_2561 message, double defaultValue, double min, double max, int displayedPrecision, String name, Consumer<Double> onChanged) {
        super(x, y, width, height, message);
        this.position = (defaultValue - min) / (max - min);
        this.defaultValue = class_3532.method_15350((double)defaultValue, (double)min, (double)max);
        this.min = min;
        this.max = max;
        String zeros = "#".repeat(displayedPrecision);
        this.displayFormat = new DecimalFormat("#" + (String)(zeros.isEmpty() ? "" : "." + zeros));
        this.name = name;
        this.onChanged = onChanged;
        this.updateMessage();
    }

    public Slider setHorizontalGradient(int leftColor, int rightColor) {
        this.horizontalGradient = Pair.of((Object)leftColor, (Object)rightColor);
        return this;
    }

    public void removeHorizontalGradient() {
        this.horizontalGradient = null;
    }

    protected class_2960 getSprite() {
        return this.method_25370() && !this.canChangeValue ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
    }

    protected class_2960 getHandleSprite() {
        return !this.field_22762 && !this.canChangeValue ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double position) {
        double d = this.position;
        this.position = class_3532.method_15350((double)position, (double)0.0, (double)1.0);
        if (d != this.position) {
            this.applyValue();
        }
        this.updateMessage();
    }

    public Double getValue() {
        return class_3532.method_15390((double)this.min, (double)this.max, (double)this.position);
    }

    public void setValue(double value) {
        double positionFromValue = (value - this.min) / (this.max - this.min);
        this.setPosition(positionFromValue);
    }

    public void resetToDefault() {
        this.setValue(this.defaultValue);
    }

    protected void updateMessage() {
        this.method_25355((class_2561)class_2561.method_43470((String)(this.name + ": " + this.displayFormat.format(this.getValue()))));
    }

    protected void applyValue() {
        this.onChanged.accept(this.getValue());
    }

    public void method_25348(double mouseX, double mouseY) {
        this.setPositionFromMouse(mouseX);
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (!focused) {
            this.canChangeValue = false;
        } else {
            class_8015 inputType = class_310.method_1551().method_48186();
            if (inputType == class_8015.field_41778 || inputType == class_8015.field_41780) {
                this.canChangeValue = true;
            }
        }
    }

    protected void setPositionFromMouse(double mouseX) {
        this.setPosition((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    public void method_25357(double mouseX, double mouseY) {
        super.method_25354(class_310.method_1551().method_1483());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1 && this.field_22763 && this.field_22764 && this.method_25361(mouseX, mouseY)) {
            this.resetToDefault();
            this.method_25354(Minecrft.get().method_1483());
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        this.setPositionFromMouse(mouseX);
        super.method_25349(mouseX, mouseY, dragX, dragY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_8494.method_51255((int)keyCode)) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean bl;
            boolean bl2 = bl = keyCode == 263;
            if (bl || keyCode == 262) {
                float f = bl ? -1.0f : 1.0f;
                this.setPosition(this.position + (double)(f / (float)(this.field_22758 - 8)));
                return true;
            }
        }
        return false;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_310 minecraft = class_310.method_1551();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.method_52706(this.getSprite(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        if (this.field_22763 && this.horizontalGradient != null) {
            this.fillHorizontalGradient(guiGraphics, this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + this.method_25368() - 1, this.method_46427() + this.method_25364() - 1, (Integer)this.horizontalGradient.getFirst(), (Integer)this.horizontalGradient.getSecond());
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 50.0f);
        guiGraphics.method_52706(this.getHandleSprite(), this.method_46426() + (int)(this.position * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364());
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        int textColor = (this.field_22763 ? 0xFFFFFF : 0xA0A0A0) | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24;
        this.method_49604(guiGraphics, minecraft.field_1772, 2, textColor);
        guiGraphics.method_51448().method_22909();
    }

    private void fillHorizontalGradient(class_332 guiGraphics, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        class_4588 consumer = guiGraphics.method_51450().getBuffer(class_1921.method_51784());
        Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
        consumer.method_22918(matrix4f, (float)x1, (float)y1, 0.0f).method_39415(colorFrom);
        consumer.method_22918(matrix4f, (float)x1, (float)y2, 0.0f).method_39415(colorFrom);
        consumer.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_39415(colorTo);
        consumer.method_22918(matrix4f, (float)x2, (float)y1, 0.0f).method_39415(colorTo);
    }

    @NotNull
    protected class_5250 method_25360() {
        return class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.method_25369()});
    }

    public void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.field_22763) {
            if (this.method_25370()) {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.hovered"));
            }
        }
    }
}

