/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.ResizedImage;
import net.minecraft.class_5253;

public class TrichromeImage
implements Image {
    private final Image red;
    private final Image green;
    private final Image blue;
    private final int width;
    private final int height;

    public TrichromeImage(Image red, Image green, Image blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.width = Math.min(red.width(), Math.min(green.width(), blue.width()));
        this.height = Math.min(red.height(), Math.min(green.height(), blue.height()));
        Preconditions.checkArgument((this.width > 0 ? 1 : 0) != 0, (String)"Cannot create TrichromeImage: smallest image should have width larger than 0. {%s, %s, %s}", (Object)red, (Object)green, (Object)blue);
        Preconditions.checkArgument((this.height > 0 ? 1 : 0) != 0, (String)"Cannot create TrichromeImage: smallest image should have height larger than 0. {%s, %s, %s}", (Object)red, (Object)green, (Object)blue);
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public int getPixelARGB(int x, int y) {
        return class_5253.class_5254.method_27764((int)class_5253.class_5254.method_27762((int)this.red.getPixelARGB(x, y)), (int)class_5253.class_5254.method_27765((int)this.red.getPixelARGB(x, y)), (int)class_5253.class_5254.method_27766((int)this.green.getPixelARGB(x, y)), (int)class_5253.class_5254.method_27767((int)this.blue.getPixelARGB(x, y)));
    }

    public static TrichromeImage withSize(Image red, Image green, Image blue, int width, int height) {
        return new TrichromeImage(new ResizedImage(red, width, height), new ResizedImage(green, width, height), new ResizedImage(blue, width, height));
    }
}

