/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.commands.exposure;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.commands.argument.ExposureLookArgument;
import io.github.mortuusars.exposure.commands.argument.SizeMultiplierArgument;
import io.github.mortuusars.exposure.commands.suggestion.ExposureIdSuggestionProvider;
import io.github.mortuusars.exposure.data.export.ExportLook;
import io.github.mortuusars.exposure.data.export.ExportSize;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.ExportS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ExportStopS2CP;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class ExportCommand {
    private static final Map<Integer, Long> EXPORT_CONFIRMATIONS = new HashMap<Integer, Long>();

    public static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"export").requires(stack -> stack.method_9259(3))).then(ExportCommand.id())).then(ExportCommand.all())).then(class_2170.method_9247((String)"stop").executes(context -> {
            Packets.sendToClient(ExportStopS2CP.INSTANCE, ((class_2168)context.getSource()).method_9207());
            return 0;
        }));
    }

    private static ArgumentBuilder<class_2168, ?> id() {
        return class_2170.method_9247((String)"id").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ExposureIdSuggestionProvider()).executes(context -> ExportCommand.exportExposures((class_2168)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), ExportSize.X1, ExportLook.REGULAR))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"size", (ArgumentType)new SizeMultiplierArgument()).executes(context -> ExportCommand.exportExposures((class_2168)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), SizeMultiplierArgument.getSize(context, "size"), ExportLook.REGULAR))).then(class_2170.method_9244((String)"look", (ArgumentType)new ExposureLookArgument()).executes(context -> ExportCommand.exportExposures((class_2168)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), SizeMultiplierArgument.getSize(context, "size"), ExposureLookArgument.getLook(context, "look"))))));
    }

    private static ArgumentBuilder<class_2168, ?> all() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"all").executes(context -> ExportCommand.exportAll((class_2168)context.getSource(), ExportSize.X1, ExportLook.REGULAR))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"size", (ArgumentType)new SizeMultiplierArgument()).executes(context -> ExportCommand.exportAll((class_2168)context.getSource(), SizeMultiplierArgument.getSize(context, "size"), ExportLook.REGULAR))).then(class_2170.method_9244((String)"look", (ArgumentType)new ExposureLookArgument()).executes(context -> ExportCommand.exportAll((class_2168)context.getSource(), SizeMultiplierArgument.getSize(context, "size"), ExposureLookArgument.getLook(context, "look")))));
    }

    private static int exportAll(class_2168 stack, ExportSize size, ExportLook look) throws CommandSyntaxException {
        List<String> ids = ExposureServer.exposureRepository().getAllIds();
        return ExportCommand.confirmExportAll(stack, ids, size, look) ? ExportCommand.exportExposures(stack, ids, size, look) : 0;
    }

    private static boolean confirmExportAll(class_2168 stack, List<String> ids, ExportSize size, ExportLook look) throws CommandSyntaxException {
        boolean confirmed;
        class_3222 player = stack.method_9207();
        int count = ids.size();
        if (count < 50) {
            return true;
        }
        @Nullable Long timestamp = EXPORT_CONFIRMATIONS.get(player.method_5628());
        boolean bl = confirmed = timestamp != null && player.method_37908().method_8510() - timestamp < 6000L;
        if (!confirmed) {
            EXPORT_CONFIRMATIONS.put(player.method_5628(), player.method_37908().method_8510());
            stack.method_9226(() -> class_2561.method_43469((String)"command.exposure.export.confirmation", (Object[])new Object[]{count}).method_27696(class_2583.field_24360.method_36139(16770531)).method_10852((class_2561)class_2561.method_43471((String)"command.exposure.export.confirm").method_27696(class_2583.field_24360.method_36139(16741225).method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"command.exposure.export.confirm.tooltip"))).method_10958(new class_2558(class_2558.class_2559.field_11750, "/exposure export all " + size.method_15434() + " " + look.method_15434())))), true);
            return false;
        }
        EXPORT_CONFIRMATIONS.remove(player.method_5628());
        return true;
    }

    private static int exportExposures(class_2168 stack, List<String> exposureIds, ExportSize size, ExportLook look) throws CommandSyntaxException {
        class_3222 player = stack.method_9207();
        Packets.sendToClient(new ExportS2CP(exposureIds, size, look), player);
        return 0;
    }
}

