/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.fabric;

import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeConfigRegistry;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.Filter;
import io.github.mortuusars.exposure.data.Lens;
import io.github.mortuusars.exposure.event.CommonEvents;
import io.github.mortuusars.exposure.event.ServerEvents;
import io.github.mortuusars.exposure.network.fabric.FabricC2SPackets;
import io.github.mortuusars.exposure.network.fabric.FabricS2CPackets;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_7225;
import net.minecraft.class_79;
import net.minecraft.class_83;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;

public class ExposureFabric
implements ModInitializer {
    @Nullable
    public static MinecraftServer server = null;

    public void onInitialize() {
        Exposure.init();
        DynamicRegistries.registerSynced(Exposure.Registries.COLOR_PALETTE, ColorPalette.CODEC, ColorPalette.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(Exposure.Registries.LENS, Lens.CODEC, Lens.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(Exposure.Registries.FILTER, Filter.CODEC, Filter.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        NeoForgeConfigRegistry.INSTANCE.register("exposure", ModConfig.Type.SERVER, (IConfigSpec)Config.Server.SPEC);
        NeoForgeConfigRegistry.INSTANCE.register("exposure", ModConfig.Type.COMMON, (IConfigSpec)Config.Common.SPEC);
        NeoForgeConfigRegistry.INSTANCE.register("exposure", ModConfig.Type.CLIENT, (IConfigSpec)Config.Client.SPEC);
        CommandRegistrationCallback.EVENT.register(CommonEvents::registerCommands);
        Exposure.Stats.register();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            ServerEvents.serverStarted(server);
            ExposureFabric.server = server;
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            ServerEvents.serverStopped(server);
            ExposureFabric.server = null;
        });
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> ServerEvents.syncDatapack(Stream.of(player)));
        LootTableEvents.MODIFY.register(ExposureFabric::modifyLoot);
        FabricC2SPackets.register();
        FabricS2CPackets.register();
    }

    private static void modifyLoot(class_5321<class_52> tableKey, class_52.class_53 builder, LootTableSource source, class_7225.class_7874 provider) {
        if (!((Boolean)Config.Common.GENERATE_LOOT.get()).booleanValue() || !source.isBuiltin()) {
            return;
        }
        if (class_39.field_356.equals(tableKey)) {
            builder.pool(class_55.method_347().method_351((class_79.class_80)class_83.method_428(Exposure.LootTables.SIMPLE_DUNGEON_INJECT)).method_355());
        }
        if (class_39.field_472.equals(tableKey)) {
            builder.pool(class_55.method_347().method_351((class_79.class_80)class_83.method_428(Exposure.LootTables.ABANDONED_MINESHAFT_INJECT)).method_355());
        }
        if (class_39.field_800.equals(tableKey)) {
            builder.pool(class_55.method_347().method_351((class_79.class_80)class_83.method_428(Exposure.LootTables.STRONGHOLD_CROSSING_INJECT)).method_355());
        }
        if (class_39.field_16748.equals(tableKey)) {
            builder.pool(class_55.method_347().method_351((class_79.class_80)class_83.method_428(Exposure.LootTables.VILLAGE_PLAINS_HOUSE_INJECT)).method_355());
        }
        if (class_39.field_841.equals(tableKey)) {
            builder.pool(class_55.method_347().method_351((class_79.class_80)class_83.method_428(Exposure.LootTables.SHIPWRECK_MAP_INJECT)).method_355());
        }
    }
}

