/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin;

import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraOnStand;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.entity.CameraOperator;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309
implements CameraHolder,
CameraOperator {
    @Unique
    @Nullable
    protected Camera activeExposureCamera;
    @Unique
    protected float oExposureCameraActionAnim = 0.0f;
    @Unique
    protected float exposureCameraActionAnim = 0.0f;

    @Shadow
    public abstract class_1661 method_31548();

    protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public Optional<class_1657> getPlayerExecutingExposure() {
        return Optional.of((class_1657)this);
    }

    @Override
    public Optional<class_1657> getPlayerAwardedForExposure() {
        return Optional.of((class_1657)this);
    }

    @Override
    @NotNull
    public class_1297 getExposureAuthorEntity() {
        return this;
    }

    @Override
    public Optional<CameraOperator> getExposureCameraOperator() {
        return Optional.of(this);
    }

    @Override
    @Nullable
    public Camera getActiveExposureCamera() {
        if (this.activeExposureCamera != null && !this.activeExposureCamera.isActive()) {
            return null;
        }
        return this.activeExposureCamera;
    }

    @Override
    public void setActiveExposureCamera(@Nullable Camera camera) {
        this.activeExposureCamera = camera;
    }

    @Override
    public void removeActiveExposureCamera() {
        this.activeExposureCamera = null;
    }

    @Override
    public float getExposureCameraActionAnim(float partialTick) {
        float delta = this.exposureCameraActionAnim - this.oExposureCameraActionAnim;
        if (delta < 0.0f) {
            delta += 1.0f;
        }
        return this.oExposureCameraActionAnim + delta * partialTick;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (!this.method_37908().method_8608() && this.activeExposureCamera != null && !this.activeExposureCamera.isActive()) {
            this.activeExposureCamera.deactivate();
            this.removeActiveExposureCamera();
        }
        this.oExposureCameraActionAnim = this.exposureCameraActionAnim;
        long lastActionTime = -1L;
        if (this.activeExposureCamera != null) {
            lastActionTime = this.activeExposureCamera.map(CameraItem::getLastActionTime).orElse(-1L);
        } else {
            class_1792 class_17922 = this.method_6047().method_7909();
            if (class_17922 instanceof CameraItem) {
                CameraItem item = (CameraItem)class_17922;
                lastActionTime = item.getLastActionTime(this.method_6047());
            } else {
                class_17922 = this.method_6079().method_7909();
                if (class_17922 instanceof CameraItem) {
                    CameraItem item = (CameraItem)class_17922;
                    lastActionTime = item.getLastActionTime(this.method_6079());
                }
            }
        }
        int actionTime = (int)(this.method_37908().method_8510() - lastActionTime);
        this.exposureCameraActionAnim = Math.clamp((float)actionTime / 10.0f, 0.0f, 1.0f);
    }

    @Inject(method={"blockActionRestricted"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBlockActionRestricted(class_1937 level, class_2338 pos, class_1934 gameMode, CallbackInfoReturnable<Boolean> cir) {
        if (this.getActiveExposureCamera() instanceof CameraOnStand) {
            cir.setReturnValue((Object)true);
        }
    }
}

